<?php require_once('header.php'); ?>
<?php
// Fetch order ID from the URL (e.g., view-order-details.php?id=ORDER_ID)
$order_id = isset($_GET['id']) ? $_GET['id'] : '';

if ($order_id == '') {
    echo "<script>alert('Invalid Order ID');</script>";
    exit;
}

// Fetch order details from the database
$statement = $pdo->prepare("SELECT * FROM tbl_payment WHERE payment_id=?");
$statement->execute(array($order_id));
$order = $statement->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    echo "<script>alert('Order not found');</script>";
    exit;
}

// Fetch customer details
$statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=?");
$statement->execute(array($order['customer_id']));
$customer = $statement->fetch(PDO::FETCH_ASSOC);

// Fetch product details for the order
$statement = $pdo->prepare("SELECT * FROM tbl_order WHERE payment_id=?");
$statement->execute(array($order_id));
$products = $statement->fetchAll(PDO::FETCH_ASSOC);
?>
<style>
    /* Product Info Section */
.product-info {
    margin-top: 20px;
}

/* Card Styling */
.card {
    border: 1px solid #e3e3e3;
    border-radius: 8px;
    transition: transform 0.2s, box-shadow 0.2s;
}

.card:hover {
    transform: scale(1.03);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

/* Card Body */
.card-body {
    padding: 15px;
    font-family: 'Arial', sans-serif;
}

/* Card Title */
.card-title {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 10px;
}

/* Card Text */
.card-text {
    font-size: 14px;
    line-height: 1.6;
    color: #555;
    margin-bottom: 15px;
}

/* Button Styling */
.btn {
    font-size: 12px;
    padding: 5px 10px;
    border-radius: 20px;
    transition: background-color 0.3s, color 0.3s;
}

.btn:hover {
    background-color: #007bff;
    color: #fff;
}

/* Image Button Colors */
.btn-outline-info {
    border-color: #17a2b8;
    color: #17a2b8;
}

.btn-outline-info:hover {
    background-color: #17a2b8;
    color: #fff;
}

.btn-outline-secondary {
    border-color: #6c757d;
    color: #6c757d;
}

.btn-outline-secondary:hover {
    background-color: #6c757d;
    color: #fff;
}

/* Row and Column Spacing */
.row {
    margin-left: 0;
    margin-right: 0;
}

.col-md-4 {
    padding-left: 15px;
    padding-right: 15px;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .card-title {
        font-size: 16px;
    }

    .card-text {
        font-size: 13px;
    }

    .btn {
        font-size: 10px;
        padding: 4px 8px;
    }
}

</style>

<section class="content-header">
    <div class="content-header-left">
        <h1>Order Details</h1>
    </div>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-info">
                <div class="box-body">

                    <!-- Customer Information Section -->
                    <div class="customer-info">
                        <h4><b>Customer Information</b></h4>
                        <table class="table table-bordered table-striped">
                            <tr><th>Customer Name</th><td><?php echo htmlspecialchars($customer['cust_name']); ?></td></tr>
                            <tr><th>Email</th><td><?php echo htmlspecialchars($customer['cust_email']); ?></td></tr>
                            <tr><th>Phone</th><td><?php echo htmlspecialchars($customer['cust_phone']); ?></td></tr>
                            <tr><th>Landmark</th><td><?php echo htmlspecialchars($customer['cust_b_landmark']); ?></td></tr>
                            <tr><th>Address</th><td><?php echo htmlspecialchars($customer['cust_b_address']); ?></td></tr>
                            <tr><th>Second Address</th><td><?php echo htmlspecialchars($customer['cust_b_address_two']); ?></td></tr>
                            <tr><th>City</th><td><?php echo htmlspecialchars($customer['cust_b_city']); ?></td></tr>
                            <tr><th>State</th><td><?php echo htmlspecialchars($customer['cust_b_state']); ?></td></tr>
                            <tr><th>Postal Code</th><td><?php echo htmlspecialchars($customer['cust_b_zip']); ?></td></tr>
                        </table>
                    </div>
                    
                    <!-- Shipping Information Section -->
                    <div class="customer-info">
                        <h4><b>Shipping Information</b></h4>
                        <table class="table table-bordered table-striped">
                            <tr><th>Shipping Status</th><td><?php echo htmlspecialchars($order['shipping_status']); ?></td></tr>
                            <tr><th>Address</th><td><?php echo htmlspecialchars($customer['cust_s_address']); ?></td></tr>
                            <tr><th>City</th><td><?php echo htmlspecialchars($customer['cust_s_city']); ?></td></tr>
                            <tr><th>State</th><td><?php echo htmlspecialchars($customer['cust_s_state']); ?></td></tr>
                            <tr><th>Postal Code</th><td><?php echo htmlspecialchars($customer['cust_s_zip']); ?></td></tr>
                        </table>
                    </div>

                    <!-- Order Payment Information Section -->
                    <div class="order-info">
                        <h4><b>Order Payment Information</b></h4>
                        <table class="table table-bordered table-striped">
                            <tr><th>Payment Method</th><td><?php echo htmlspecialchars($order['payment_method']); ?></td></tr>
                            <tr><th>Transaction Id</th><td><?php echo htmlspecialchars($order['txnid']); ?></td></tr>
                            <tr><th>Payment Status</th><td><?php echo htmlspecialchars($order['payment_status']); ?></td></tr>
                            <tr><th>Paid Amount</th><td>₹<?php echo htmlspecialchars($order['paid_amount']); ?></td></tr>
                            <tr><th>Payment Date</th><td><?php echo htmlspecialchars($order['payment_date']); ?></td></tr>
                        </table>
                    </div>
                    <div class="invoice-info">
                        <?php if (!empty($order['invoice_path'])): ?>
                            <h4><b>Invoice</b></h4>
                            <div class="alert alert-success d-flex align-items-center" role="alert">
                                <i class="bi bi-file-earmark-text me-2"></i>
                                <span>Your invoice is available:</span>
                                <a href="<?php echo htmlspecialchars($order['invoice_path']); ?>" 
                                   class="ms-2 text-decoration-none text-primary fw-bold" 
                                   target="_blank">
                                    <i class="bi bi-download"></i> Download Invoice
                                </a>
                            </div>
                        <?php else: ?>
                            <h4><b>Invoice</b></h4>
                            <div class="alert alert-warning d-flex align-items-center" role="alert">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <span>No invoice uploaded for this order yet.</span>
                            </div>
                        <?php endif; ?>
                    </div>
                        <!-- Product Details Section -->
                    <div class="product-info">
                        <h4><b>Ordered Products</b></h4>
                        <div class="row">
                            <?php foreach ($products as $product): ?>
                                <div class="col-md-4 mb-4">
                                    <div class="card shadow-sm">
                                        <!-- Product Image -->
                                        <div class="card-body">
                                            <!-- Product Name -->
                                            <h5 class="card-title text-primary"><?php echo htmlspecialchars($product['product_name']); ?></h5>
                                            
                                            <!-- Product Details -->
                                            <p class="card-text">
                                                <i class="fas fa-ruler-combined"></i> <b>Size:</b> <?php echo htmlspecialchars($product['size']); ?><br>
                                                <i class="fas fa-palette"></i> <b>Color:</b> <?php echo htmlspecialchars($product['color']); ?><br>
                                                <i class="fas fa-sort-amount-up"></i> <b>Quantity:</b> <?php echo htmlspecialchars($product['quantity']); ?><br>
                                                <i class="fas fa-tag"></i> <b>Unit Price:</b> ₹<?php echo htmlspecialchars($product['unit_price']); ?><br>
                                                <i class="fas fa-wallet"></i> <b>Total Price:</b> ₹<?php echo htmlspecialchars($product['quantity'] * $product['unit_price']); ?>
                                            </p>
                                            
                                            <!-- Buttons for Images -->
                                            <div class="d-flex justify-content-between">
                                                <?php if (!empty($product['logo_image'])): ?>
                                                    <a href="../<?php echo htmlspecialchars($product['logo_image']); ?>" target="_blank" class="btn btn-outline-info btn-sm">
                                                        <i class="fas fa-image"></i> View Logo
                                                    </a>
                                                <?php endif; ?>
                                                <?php if (!empty($product['custom_image'])): ?>
                                                    <a href="../<?php echo htmlspecialchars($product['custom_image']); ?>" target="_blank" class="btn btn-outline-secondary btn-sm">
                                                        <i class="fas fa-image"></i> View Custom Image
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once('footer.php'); ?>