<?php
include 'inc/config.php';
if (isset($_POST['upload_invoice'])) {
    $payment_id = $_POST['payment_id'];
    
    // Handle the uploaded file
    if (isset($_FILES['invoice_file']) && $_FILES['invoice_file']['error'] == 0) {
        $file = $_FILES['invoice_file'];
        $file_name = $file['name'];
        $file_tmp_name = $file['tmp_name'];
        $file_size = $file['size'];
        $file_type = $file['type'];
        
        // File validation
        $allowed_extensions = ['pdf', 'jpg', 'jpeg', 'png'];
        $file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

        if (!in_array($file_extension, $allowed_extensions)) {
            echo "<script>alert('Invalid file type. Please upload a PDF, JPG, JPEG, or PNG file.');</script>";
        } else {
            // Define the path to save the uploaded file
            $upload_dir = '../assets/uploads/invoices/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }

            $new_file_name = 'invoice_' . time() . '.' . $file_extension;
            $file_path = $upload_dir . $new_file_name;

            // Move the uploaded file to the server
            if (move_uploaded_file($file_tmp_name, $file_path)) {
                // Save the file path in the database
                $statement = $pdo->prepare("UPDATE tbl_payment SET invoice_path = ? WHERE payment_id = ?");
                $statement->execute([$file_path, $payment_id]);

                echo "<script>alert('Invoice uploaded successfully.'); window.location.href='order.php';</script>";
            } else {
                echo "<script>alert('Failed to upload the invoice.');</script>";
            }
        }
    } else {
        echo "<script>alert('Please select a file to upload.');</script>";
    }
}
?>