<?php
require_once('admin/inc/config.php');
session_start(); // Start session to store OTP

if (isset($_POST['action'])) {
    $action = $_POST['action'];

    // Send OTP to Mobile
    if ($action == 'send_mobile_otp') {
        $phone = $_POST['phone'];

        // Validate mobile number (check if it is 10 digits long)
        if (strlen($phone) != 10 || !preg_match('/^[0-9]{10}$/', $phone)) {
            echo json_encode(['status' => 'error', 'message' => 'Please enter a valid 10-digit mobile number']);
            exit;
        }

        // Generate OTP
        $otp = rand(100000, 999999);

        // Store OTP in the session
        $_SESSION['otp'] = $otp;

        // Fast2SMS API parameters
        $message = 178250; 
        $apiKey = 'dS772wjwU2bfonW4mTbtOZFk5xH7Dd6H6oKiKGLPEfwhMjkXQ95bhVeeY9NY';
        $senderId = 'ARKESL';
        $route = 'dlt';
        $variables_values = $otp;

        // Construct API URL
        $url = "https://www.fast2sms.com/dev/bulkV2?authorization=$apiKey&route=$route&sender_id=$senderId&message=$message&variables_values=$variables_values&flash=0&numbers=$phone";

        // cURL request to Fast2SMS API
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo json_encode(['status' => 'error', 'message' => 'cURL Error: ' . curl_error($ch)]);
        } else {
            $responseData = json_decode($response, true);
            if (isset($responseData['return']) && $responseData['return'] === true) {
                echo json_encode(['status' => 'success', 'message' => 'OTP sent successfully']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Failed to send OTP', 'details' => $responseData]);
            }
        }
        curl_close($ch);
    }

    // Verify OTP
    if ($action == 'verify_mobile_otp') {
        $otp = $_POST['otp'];

        if (isset($_SESSION['otp']) && $_SESSION['otp'] == $otp) {
            echo json_encode(['status' => 'success', 'message' => 'OTP verified successfully']);
            unset($_SESSION['otp']); // Remove OTP after successful verification
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid OTP']);
        }
    }
}
