<?php include('include/header.php')?>
<?php
$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
$statement->execute();
$result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
foreach ($result as $row) {
    $banner_checkout = $row['banner_checkout'];
}
?>
<?php
// Check if customer is logged in
if (!isset($_SESSION['customer']) || empty($_SESSION['customer'])) {
    // If not logged in, redirect to login page
    $_SESSION['ark_login'] = 1;
    header("Location: login.php");
    exit(); // Make sure the script stops executing after the redirect
}
if(!isset($_SESSION['cart_p_id'])) {
    header('location: cart.php');
    exit;
}
?>
<?php
// Check if the form is submitted and process the data
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cust_id = $_SESSION['customer']['cust_id']; 
    $same_address = isset($_POST['same_address']) ? 1 : 0;
    
    $cust_s_address = $same_address ? $_POST['cust_b_address'] : $_POST['cust_s_address'];
    $cust_s_city = $same_address ? $_POST['cust_b_city'] : $_POST['cust_s_city'];
    $cust_s_state = $same_address ? $_POST['cust_b_state'] : $_POST['cust_s_state'];
    $cust_s_country = $same_address ? $_POST['cust_b_country'] : $_POST['cust_s_country'];
    $cust_s_zip = $same_address ? $_POST['cust_b_zip'] : $_POST['cust_s_zip'];

    // Update query
    $update_query = "UPDATE tbl_customer SET 
        cust_name = :cust_b_name,
        cust_b_name = :cust_b_name,
        cust_b_cname = :cust_b_cname,
        cust_b_phone = :cust_b_phone,
        cust_email = :cust_email,
        cust_b_address = :cust_b_address,
        cust_b_address_two = :cust_b_address_two,
        cust_b_city = :cust_b_city,
        cust_b_state = :cust_b_state,
        cust_b_country = :cust_b_country,
        cust_b_zip = :cust_b_zip,
        cust_b_landmark = :cust_b_landmark,
        cust_s_address = :cust_s_address,
        cust_s_city = :cust_s_city,
        cust_s_state = :cust_s_state,
        cust_s_country = :cust_s_country,
        cust_s_zip = :cust_s_zip
    WHERE cust_id = :cust_id"; 

    // Prepare the data from the form submission
    $stmt = $pdo->prepare($update_query);

    // Bind the form data to the query parameters
    $stmt->bindParam(':cust_name', $_POST['cust_b_name']);
    $stmt->bindParam(':cust_b_name', $_POST['cust_b_name']);
    $stmt->bindParam(':cust_b_cname', $_POST['cust_b_cname']);
    $stmt->bindParam(':cust_b_phone', $_POST['cust_b_phone']);
    $stmt->bindParam(':cust_email', $_POST['cust_email']);
    $stmt->bindParam(':cust_b_address', $_POST['cust_b_address']);
    $stmt->bindParam(':cust_b_address_two', $_POST['cust_b_address_two']);
    $stmt->bindParam(':cust_b_city', $_POST['cust_b_city']);
    $stmt->bindParam(':cust_b_state', $_POST['cust_b_state']);
    $stmt->bindParam(':cust_b_country', $_POST['cust_b_country']);
    $stmt->bindParam(':cust_b_zip', $_POST['cust_b_zip']);
    $stmt->bindParam(':cust_b_landmark', $_POST['cust_b_landmark']);
    $stmt->bindParam(':cust_s_address', $cust_s_address);
    $stmt->bindParam(':cust_s_city', $cust_s_city);
    $stmt->bindParam(':cust_s_state', $cust_s_state);
    $stmt->bindParam(':cust_s_country', $cust_s_country);
    $stmt->bindParam(':cust_s_zip', $cust_s_zip);
    $stmt->bindParam(':cust_id', $cust_id);  // Correct binding for cust_id

    // Execute the query to update customer data
    if ($stmt->execute()) {
        if ($stmt->rowCount() > 0) {
            echo "<script>alert('Address details updated successfully!');</script>";
        } else {
            echo "<script>alert('No changes made to the database.');</script>";
        }
    } else {
        echo "<script>alert('Error updating address details: " . implode(' ', $stmt->errorInfo()) . "');</script>";
    }
}

// Fetch current customer details
$statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id = :cust_id");
$statement->execute(array(':cust_id' => $_SESSION['customer']['cust_id'])); 
$customer = $statement->fetch(PDO::FETCH_ASSOC);
$_SESSION['customer']['email'] = $customer['cust_email'];
?>
 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section breadcrumb__bg" style="background-image: url(assets/uploads/<?php echo $banner_checkout; ?>);">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25"><?php echo LANG_VALUE_22; ?></h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white"><?php echo LANG_VALUE_22; ?></span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->
       
       <!-- Start checkout page area -->
    <div class="checkout__page--area">
        <div class="container">
        <?php if(!isset($_SESSION['customer'])): ?>
                    <div class="pt-5 pb-5 text-center">
                        <a href="login.php" class="continue__shipping--btn primary__btn border-radius-5"><?php echo LANG_VALUE_160; ?></a>
                    </div>
                <?php else: ?>
            <div class="checkout__page--inner d-flex">
                <div class="main checkout__mian">
                <form method="POST" action="">
                    <main class="main__content_wrapper">
                            <div class="checkout__content--step section__shipping--address pt-10">
                                <div class="section__header mb-25">
                                    <h3 class="section__header--title">Billing address</h3>
                                    <p class="section__header--desc">Select the address that matches your card or payment method.</p>
                                </div>
                                <div class="checkout__content--step__inner3 border-radius-5">
                                    <div class="checkout__content--input__box--wrapper ">
                                        <div class="row">
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list ">
                                                    <label>Full Name*
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_name" placeholder="Full name" value="<?php echo $customer['cust_b_name']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label> Company Name (optional)
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_cname" placeholder="Company name (optional)" value="<?php echo $customer['cust_b_cname']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Email Address (optional)
                                                        <input class="checkout__input--field border-radius-5" name="cust_email" placeholder="Email Address" value="<?php echo $customer['cust_email']; ?>"  type="email">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Phone Number*
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_phone" placeholder="Phone number" value="<?php echo $customer['cust_b_phone']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Postal Code
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_zip" id="pincode" placeholder="Postal code" value="<?php echo $customer['cust_b_zip']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>City
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_city" id="city" placeholder="City" value="<?php echo $customer['cust_b_city']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>State
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_state" id="state" placeholder="State" value="<?php echo $customer['cust_b_state']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                           
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list checkout__input--select select">
                                                    <label class="checkout__select--label" for="country">Country/region</label>
                                                    <select class="checkout__input--select__field border-radius-5" name="cust_b_country" id="cust_b_country">
                                                    <?php
                                                    // Fetch all countries from the database
                                                    $statement = $pdo->prepare("SELECT * FROM tbl_country");
                                                    $statement->execute();
                                                    $countries = $statement->fetchAll(PDO::FETCH_ASSOC);

                                                    foreach ($countries as $row) {
                                                        // Check if the country is selected (based on current customer data)
                                                        $selected = ($row['country_id'] == $customer['cust_b_country']) ? 'selected' : '';
                                                        echo "<option value='" . $row['country_id'] . "' $selected>" . $row['country_name'] . "</option>";
                                                    }
                                                    ?>
                                                </select>
                                                </div>
                                            </div>
                                             <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Landmark
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_landmark" placeholder="Landmark" value="<?php echo $customer['cust_b_landmark']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Address
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_address" placeholder="Apartment, suite, etc." value="<?php echo $customer['cust_b_address']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Second Address (optional)
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_address_two" placeholder="Apartment, suite, etc. (optional)" value="<?php echo $customer['cust_b_address_two']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 mb-12">
                                <div class="checkout__input--list">
                                    <label>
                                        <input type="checkbox" id="same_address" name="same_address" checked>
                                        Shipping address is the same as billing address
                                    </label>
                                </div>
                            </div>

                              <div class="checkout__content--step section__shipping--address pt-10" id="shipping_address_section" style="display:none;">
                                <div class="section__header mb-25">
                                    <h3 class="section__header--title">Shipping address</h3>
                                    <!-- <p class="section__header--desc">Select the address that matches your card or payment method.</p> -->
                                </div>
                                <div class="checkout__content--step__inner3 border-radius-5">
                                    <div class="checkout__content--input__box--wrapper ">
                                        <div class="row">
                                             <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Postal Code
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_zip" id="shipping_pincode" placeholder="Postal code" value="<?php echo $customer['cust_s_zip']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>City
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_city" id="shipping_city" placeholder="City" value="<?php echo $customer['cust_s_city']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>State
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_state" id="shipping_state" placeholder="State" value="<?php echo $customer['cust_s_state']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                           
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list checkout__input--select select">
                                                  <label class="checkout__select--label" for="country">Country/region</label>
                                                    <select class="checkout__input--select__field border-radius-5" name="cust_s_country" id="cust_s_country">
                                                        <?php
                                                        // Fetch all countries from the database
                                                        $statement = $pdo->prepare("SELECT * FROM tbl_country");
                                                        $statement->execute();
                                                        $countries = $statement->fetchAll(PDO::FETCH_ASSOC);

                                                        foreach ($countries as $row) {
                                                            // Check if the country is selected (based on current customer data)
                                                            $selected = ($row['country_id'] == $customer['cust_s_country']) ? 'selected' : '';
                                                            echo "<option value='" . $row['country_id'] . "' $selected>" . $row['country_name'] . "</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                           <div class="col-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Address
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_address" placeholder="Apartment, suite, etc. (optional)" value="<?php echo $customer['cust_s_address']; ?>"  type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="cart__summary--footer__btn primary__btn checkout mb-5" >Update Address</button>
                            <?php
		                $checkout_access = 1;
		                if(
		                    ($customer['cust_b_name']=='') ||
		                    // ($_SESSION['customer']['cust_b_cname']=='') ||
		                    ($customer['cust_b_phone']=='') ||
		                    ($customer['cust_b_country']=='') ||
		                    ($customer['cust_b_address']=='') ||
		                    ($customer['cust_b_city']=='') ||
		                    ($customer['cust_b_state']=='') ||
		                    ($customer['cust_b_zip']=='') ||
		                    ($customer['cust_s_country']=='') ||
		                    ($customer['cust_s_address']=='') ||
		                    ($customer['cust_s_city']=='') ||
		                    ($customer['cust_s_state']=='') ||
		                    ($customer['cust_s_zip']=='')
		                ) {
		                    $checkout_access = 0;
		                }
		                ?>
		                
                    </main>
                        </form>
                      
                </div>
                <aside class="checkout__sidebar sidebar">
                    <div class="cart__table checkout__product--table">
                        <table class="cart__table--inner">
                            <tbody class="cart__table--body">
                           <?php
                            $table_total_price = 0;
                            $total_tax = 0;
                            
                            // Initialize arrays from session
                            $arrays = ['cart_p_id', 'cart_size_id', 'cart_size_name', 'cart_color_id', 
                                       'cart_color_name', 'cart_p_qty', 'cart_p_current_price', 'cart_p_name', 
                                       'cart_p_featured_photo', 'cart_p_customization'];
                            
                            foreach($arrays as $array) {
                                $i = 0;
                                if(isset($_SESSION[$array])) {
                                    foreach($_SESSION[$array] as $key => $value) {
                                        $i++;
                                        ${'arr_'.$array}[$i] = $value;
                                    }
                                }
                            }
                            
                            for($i=1; $i<=count($arr_cart_p_id); $i++): 
                               $row_total_price = $arr_cart_p_current_price[$i] * $arr_cart_p_qty[$i];
                                $table_total_price += $row_total_price;
                                $show_tax = $gst_number;
                                   if ($show_tax) {
                                        if ($table_total_price < 1000) {
                                            $tax_rate = 0.05;
                                        } else {
                                            $tax_rate = 0.12;
                                        }
                                        $tax = $row_total_price * $tax_rate;
                                        $total_tax += $tax;
                                   }

                            ?>
                                <tr class="cart__table--body__items">
                                    <td class="cart__table--body__list">
                                        <div class="product__image two  d-flex align-items-center">
                                            <div class="product__thumbnail border-radius-5">
                                                <a href="product.php?id=<?php echo $arr_cart_p_id[$i]; ?>"><img class="border-radius-5" src="assets/uploads/<?php echo $arr_cart_p_featured_photo[$i]; ?>" alt="cart-product"></a>
                                                <span class="product__thumbnail--quantity">1</span>
                                            </div>
                                            <div class="product__description">
                                                <h3 class="product__description--name h4"><a href="product.php?id=<?php echo $arr_cart_p_id[$i]; ?>"><?php echo $arr_cart_p_name[$i]; ?></a></h3>
                                                <span class="product__description--variant text-dark">SIZE: <?php echo $arr_cart_size_name[$i]; ?></span><br>
                                                <span class="product__description--variant text-dark">COLOR: <?php echo $arr_cart_color_name[$i]; ?></span><br>
                                                <span class="product__description--variant text-dark">QTY: <?php echo $arr_cart_p_qty[$i]; ?></span>

                                                <?php if(isset($arr_cart_p_customization[$i])): ?>
                                                        <?php
                                                            if(isset($_SESSION['customizations'])){
                                                                foreach ($_SESSION['customizations'] as $customization) {
                                                                    if ($customization['customization_id'] == $arr_cart_p_customization[$i]) {
                                                                        $custom_image = $customization['custom_image'];
                                                                        $logo = $customization['logo'];
                                                                        
                                                                        echo '<span class="cart__content--variant">
                                                                        <a href="'.$custom_image.'">( CUSTOMISED IMG )</a>
                                                                        </span>';
                                                                        echo '<span class="cart__content--variant">
                                                                            <a href="'.$logo.'">( LOGO )</a>
                                                                        </span>';
                                                                    }
                                                                }
                                                            }
                                                        ?>
                                                    <?php endif; ?>


                                            </div>
                                        </div>
                                    </td>
                                    <td class="cart__table--body__list">
                                        <span class="cart__price">₹<?php echo $arr_cart_p_current_price[$i]; ?></span>
                                    </td>
                                </tr>
                                <?php endfor; ?> 
                            </tbody>
                        </table> 
                    </div>
                    <!-- <div class="checkout__discount--code">
                        <form class="d-flex" action="#">
                            <label>
                                <input class="checkout__discount--code__input--field border-radius-5" placeholder="Gift card or discount code"  type="text">
                            </label>
                            <button class="checkout__discount--code__btn primary__btn border-radius-5" type="submit">Apply</button>
                        </form>
                    </div> -->
                   
                    <div class="checkout__total">
                        <table class="checkout__total--table">
                            <tbody class="checkout__total--body">
                                <tr class="checkout__total--items">
                                    <td class="checkout__total--title text-left">Subtotal </td>
                                    <td class="checkout__total--amount text-right">₹<?php echo $table_total_price; ?></td>
                                </tr>
                                <?php
                        $statement = $pdo->prepare("SELECT * FROM tbl_shipping_cost WHERE country_id=?");
                        $statement->execute(array($_SESSION['customer']['cust_country']));
                        $total = $statement->rowCount();
                        if($total) {
                            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($result as $row) {
                                $shipping_cost = $row['amount'];
                            }
                        } else {
                            $statement = $pdo->prepare("SELECT * FROM tbl_shipping_cost_all WHERE sca_id=1");
                            $statement->execute();
                            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                            foreach ($result as $row) {
                                $shipping_cost = $row['amount'];
                            }
                        }                        
                        ?>
                                <tr class="checkout__total--items">
                                    <td class="checkout__total--title text-left"><?php echo LANG_VALUE_84; ?></td>
                                    <td class="checkout__total--amount text-right">₹<?php echo $shipping_cost; ?></td>
                                </tr>
                                <?php  if ($show_tax) { ?>
                                    <tr class="checkout__total--items">
                                        <td class="checkout__total--title text-left">
                                            GST 
                                            <?php if ($show_tax): ?>
                                                <i 
                                                    class="fas fa-info-circle info-icon" 
                                                    data-bs-toggle="tooltip" 
                                                    data-bs-html="true" 
                                                    title="GST Charges:<br>
                                                           -> 5% tax is applicable for orders below ₹1,000.<br>
                                                           -> 12% tax is applicable for orders above ₹1,000.<br>
                                                           Total GST Amount: ₹<?php echo number_format($total_tax, 2); ?>"
                                                ></i>
                                            <?php endif; ?>
                                        </td>
                                        <td class="checkout__total--amount text-right">
                                            ₹<?php echo $show_tax ? number_format($total_tax, 2) : '0.00'; ?>
                                        </td>
                                    </tr>

                                <?php
                                        } else {
                                            echo '<tr class="checkout__total--items"><td colspan="2" class="text-center">No GST applicable</td></tr>';
                                        }
                                        ?>
                            </tbody>
                            <tfoot class="checkout__total--footer">
                            <?php
                                $final_total = $table_total_price+$shipping_cost+$total_tax;
                                ?>
                                <tr class="checkout__total--footer__items">
                                    <td class="checkout__total--footer__title checkout__total--footer__list text-left">Total </td>
                                    <td class="checkout__total--footer__amount checkout__total--footer__list text-right">₹<?php echo $final_total; ?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <?php if($checkout_access == 0): ?>
		                	<div class="col-md-12">
				                <div style="color:red;font-size:22px;margin:50px 0;">
                                You must have to fill up all the billing and shipping information.
			                    </div>
	                    	</div>
	                	<?php else: ?>
                            <div class="col-md-12 mt-5">
		                		
	                            <div class="row">
                                <div class="col-lg-12 mb-12">
	                                <div class="checkout__input--list checkout__input--select select">
	                                    <label class="checkout__select--label" for=""><?php echo LANG_VALUE_34; ?> *</label>
	                                    <select name="payment_method" class="checkout__input--select__field border-radius-5" id="advFieldsStatus">
	                                        <option value=""><?php echo LANG_VALUE_35; ?></option>
	                                        <!--<option value="PayPal"><?php echo LANG_VALUE_36; ?></option>-->
	                                        <option value="Bank Deposit"><?php echo LANG_VALUE_38; ?></option>
	                                        <option value="Razorpay">Razorpay</option>
	                                    </select>
	                                </div>
	                            </div>

                                    <!--<form class="paypal" action="<?php echo BASE_URL; ?>payment/paypal/payment_process.php" method="post" id="paypal_form" target="_blank">-->
                                    <!--    <input type="hidden" name="cmd" value="_xclick" />-->
                                    <!--    <input type="hidden" name="no_note" value="1" />-->
                                    <!--    <input type="hidden" name="lc" value="UK" />-->
                                    <!--    <input type="hidden" name="currency_code" value="INR" />-->
                                    <!--    <input type="hidden" name="bn" value="PP-BuyNowBF:btn_buynow_LG.gif:NonHostedGuest" />-->

                                    <!--    <input type="hidden" name="final_total" value="<?php echo $final_total; ?>">-->
                                    <!--    <div class="col-md-12 pt-4 checkout__content--step__footer pb-5 d-flex align-items-center">-->
                                    <!--        <input type="submit" class="continue__shipping--btn primary__btn border-radius-5" value="<?php echo LANG_VALUE_46; ?>" name="form1">-->
                                    <!--        <a class="previous__link--content" href="cart.php"><?php echo LANG_VALUE_21; ?></a>-->
                                    <!--    </div>-->
                                    <!--</form>-->



                                    <form action="payment/bank/init.php" method="post" id="bank_form">
                                        <input type="hidden" name="amount" value="<?php echo $final_total; ?>">
                                        <div class="col-md-12 form-group-text">
                                            <label for=""><?php echo LANG_VALUE_43; ?></span></label><br>
                                            <?php
                                            $statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
                                            $statement->execute();
                                            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($result as $row) {
                                                echo nl2br($row['bank_detail']);
                                            }
                                            ?>
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label for=""><?php echo LANG_VALUE_44; ?> <br><span style="font-size:12px;font-weight:normal;">(<?php echo LANG_VALUE_45; ?>)</span></label>
                                            <textarea name="transaction_info" class="contact__form--textarea" cols="30" rows="10"></textarea>
                                        </div>
                                        <div class="col-md-12 pt-4 checkout__content--step__footer pb-5 d-flex align-items-center">
                                            <input type="submit" class="continue__shipping--btn primary__btn border-radius-5" value="<?php echo LANG_VALUE_46; ?>" name="form3">
                                            <a class="previous__link--content" href="cart.php"><?php echo LANG_VALUE_21; ?></a>
                                        </div>
                                    </form>
                                      <!-- Razorpay Form (Initially hidden) -->
                                     <form class="razorpay-form" action="payment/razorpay/verify_payment.php" method="post" id="razorpay_form" style="display: none;">
                                                        <input type="hidden" name="amount" value="<?php echo $final_total; ?>">
                                                        
                                                        <div class="form-footer mt-4">
                                                            <input type="submit" class="continue__shipping--btn primary__btn border-radius-5" id="rzp-button" value="Pay with Razorpay" name="form4">
                                                            <a class="previous__link--content" href="cart.php"><?php echo LANG_VALUE_21; ?></a>
                                                        </div>
                                                    </form>
	                            </div>
		                    </div>
                            <?php endif; ?>
                </aside>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- End checkout page area -->
<?php include('include/footer.php')?>
<script>
document.getElementById('same_address').addEventListener('change', function () {
    // If the checkbox is checked, copy billing details to shipping
    if (this.checked) {
        document.getElementById('shipping_address_section').style.display = 'none'; // Hide shipping address fields
        
        // Copy billing address to shipping fields
        document.getElementById('cust_s_address').value = document.getElementById('cust_b_address').value;
        document.getElementById('cust_s_city').value = document.getElementById('cust_b_city').value;
        document.getElementById('cust_s_state').value = document.getElementById('cust_b_state').value;
        document.getElementById('cust_s_country').value = document.getElementById('cust_b_country').value;
        document.getElementById('cust_s_zip').value = document.getElementById('cust_b_zip').value;
    } else {
        document.getElementById('shipping_address_section').style.display = 'block'; // Show shipping address fields
    }
});
 document.getElementById('pincode').addEventListener('input', function () {
    const pincode = this.value.trim();

    if (pincode.length === 6) {
        fetch(`https://api.postalpincode.in/pincode/${pincode}`)
            .then(response => response.json())
            .then(data => {
                if (Array.isArray(data) && data[0].Status === "Success") {
                    const postOffice = data[0].PostOffice[0];
                    document.getElementById('city').value = postOffice.District || '';
                    document.getElementById('state').value = postOffice.State || '';
                } else {
                    alert('Invalid pincode or no details found.');
                }
            })
            .catch(error => console.error('Error fetching address details:', error));
    }
});
document.getElementById('shipping_pincode').addEventListener('input', function () {
    const pincode = this.value.trim();

    if (pincode.length === 6) {
        fetch(`https://api.postalpincode.in/pincode/${pincode}`)
            .then(response => response.json())
            .then(data => {
                if (Array.isArray(data) && data[0].Status === "Success") {
                    const postOffice = data[0].PostOffice[0];
                    document.getElementById('shipping_city').value = postOffice.District || '';
                    document.getElementById('shipping_state').value = postOffice.State || '';
                } else {
                    alert('Invalid pincode or no details found.');
                }
            })
            .catch(error => console.error('Error fetching address details:', error));
    }
});
</script>
 <script>
        document.getElementById('rzp-button').onclick = function(e) {
            e.preventDefault();
            // const amount = document.getElementById('amount').value;
            const amount = document.querySelector('input[name="amount"]').value;

            // Create an order by calling the server-side script
            fetch('payment/razorpay/create_order.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'amount=' + amount
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    var options = {
                        "key": "rzp_live_ZsfcHOE1qBZL0x", 
                        "amount": amount * 100, 
                        "currency": "INR",
                        "name": "Ark Enterprises",
                        "image": "https://corporateuniforms.co.in/assets/uploads/logo.png",
                        "description": "Purchase Description",
                        "order_id": data.order_id, 
                        "handler": function (response){
                            // Send the payment details to the server for verification
                            var payment_id = response.razorpay_payment_id;
                            var order_id = response.razorpay_order_id;
                            var signature = response.razorpay_signature;

                            // Create a form to submit the payment details
                            var form = document.createElement('form');
                            form.method = 'POST';
                            form.action = 'payment/razorpay/verify_payment.php';

                            var input_payment_id = document.createElement('input');
                            input_payment_id.type = 'hidden';
                            input_payment_id.name = 'razorpay_payment_id';
                            input_payment_id.value = payment_id;
                            form.appendChild(input_payment_id);

                            var input_order_id = document.createElement('input');
                            input_order_id.type = 'hidden';
                            input_order_id.name = 'razorpay_order_id';
                            input_order_id.value = order_id;
                            form.appendChild(input_order_id);

                            var input_signature = document.createElement('input');
                            input_signature.type = 'hidden';
                            input_signature.name = 'razorpay_signature';
                            input_signature.value = signature;
                            form.appendChild(input_signature);

                            document.body.appendChild(form);
                            form.submit();
                        },
                        "prefill": {
                            "name": "<?php echo htmlspecialchars($customer['cust_b_name']); ?>",
                            "email": "<?php echo htmlspecialchars($_SESSION['customer']['email']); ?>",
                            "contact": "<?php echo htmlspecialchars($customer['cust_phone']); ?>"
                        },
                        "theme": {
                            // "color": "#F37254"
                            "color": "#8fc64d"
                        }
                    };
                    var rzp1 = new Razorpay(options);
                    rzp1.open();
                } else {
                    alert('Error: ' + data.error);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while creating the order.');
            });
        }
    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>

</body>

</html>