<?php include('include/header.php')?>
<?php
// Check if the customer is logged in or not
if(!isset($_SESSION['customer'])) {
    header('location: '.BASE_URL.'logout.php');
    exit;
} else {
    // If customer is logged in, but admin make him inactive, then force logout this user.
    $statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=? AND cust_status=?");
    $statement->execute(array($_SESSION['customer']['cust_id'],0));
    $total = $statement->rowCount();
    if($total) {
        header('location: '.BASE_URL.'logout.php');
        exit;
    }
}
?>
<?php
if (isset($_POST['form1'])) {


    // update data into the database
    $statement = $pdo->prepare("UPDATE tbl_customer SET 
                            
                            cust_b_country=?, 
                            cust_b_address=?, 
                            cust_b_city=?, 
                            cust_b_state=?, 
                            cust_b_zip=?,
                            
                            cust_s_country=?, 
                            cust_s_address=?, 
                            cust_s_city=?, 
                            cust_s_state=?, 
                            cust_s_zip=? 

                            WHERE cust_id=?");
    $statement->execute(array(
                            
                            strip_tags($_POST['cust_b_country']),
                            strip_tags($_POST['cust_b_address']),
                            strip_tags($_POST['cust_b_city']),
                            strip_tags($_POST['cust_b_state']),
                            strip_tags($_POST['cust_b_zip']),
                            
                            strip_tags($_POST['cust_s_country']),
                            strip_tags($_POST['cust_s_address']),
                            strip_tags($_POST['cust_s_city']),
                            strip_tags($_POST['cust_s_state']),
                            strip_tags($_POST['cust_s_zip']),
                            $_SESSION['customer']['cust_id']
                        ));  
   
    $success_message = LANG_VALUE_122;

    
    $_SESSION['customer']['cust_b_country'] = strip_tags($_POST['cust_b_country']);
    $_SESSION['customer']['cust_b_address'] = strip_tags($_POST['cust_b_address']);
    $_SESSION['customer']['cust_b_city'] = strip_tags($_POST['cust_b_city']);
    $_SESSION['customer']['cust_b_state'] = strip_tags($_POST['cust_b_state']);
    $_SESSION['customer']['cust_b_zip'] = strip_tags($_POST['cust_b_zip']);
    
    $_SESSION['customer']['cust_s_country'] = strip_tags($_POST['cust_s_country']);
    $_SESSION['customer']['cust_s_address'] = strip_tags($_POST['cust_s_address']);
    $_SESSION['customer']['cust_s_city'] = strip_tags($_POST['cust_s_city']);
    $_SESSION['customer']['cust_s_state'] = strip_tags($_POST['cust_s_state']);
    $_SESSION['customer']['cust_s_zip'] = strip_tags($_POST['cust_s_zip']);

}

?>
 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">My Account</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">My Account</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->

         <!-- my account section start -->
         <section class="my__account--section section--padding">
            <div class="container">
                <div class="my__account--section__inner border-radius-10 d-flex">
                    <div class="account__left--sidebar">
                        <h2 class="account__content--title h3 mb-20">My Profile</h2>
                        <ul class="account__menu">
                        <?php require_once('customer-sidebar.php'); ?>
                        </ul>
                    </div>
                    <div class="account__wrapper">
                        <div class="account__content">
                            <!-- <h2 class="account__content--title h3 mb-20">Orders History</h2>-->
                            
                            <div class="checkout__content--step section__shipping--address pt-10">
                                <div class="section__header mb-25">
                                    <!-- <h3 class="section__header--title"> <?php echo LANG_VALUE_86; ?></h3> -->
                                    <?php
                                        if($error_message != '') {
                                            echo "<p class='section__header--desc text-danger error' style='padding: 10px;background:#f1f1f1;margin-bottom:20px;'>".$error_message."</p>";
                                        }
                                        if($success_message != '') {
                                            echo "<p class='section__header--desc text-success success' style='padding: 10px;background:#f1f1f1;margin-bottom:20px;'>".$success_message."</p>";
                                        }
                                        ?>
                                </div>

                                <div class="checkout__content--step__inner3 border-radius-5">
                                    <div class="checkout__content--input__box--wrapper ">
                                    <form action="" method="post">
                                    <?php $csrf->echoInputField(); ?>
                                        <div class="row">
                                        <div class="col-6">
                                        <h3 class="section__header--title mb-5"> <?php echo LANG_VALUE_86; ?></h3>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Postal Code
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_zip" id="pincode" placeholder="Postal code" value="<?php echo $_SESSION['customer']['cust_b_zip']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>City
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_city" id="city" placeholder="City" value="<?php echo $_SESSION['customer']['cust_b_city']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>State
                                                        <input class="checkout__input--field border-radius-5" name="cust_b_state" id="state" placeholder="State" value="<?php echo $_SESSION['customer']['cust_b_state']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                           
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list checkout__input--select select">
                                                    <label class="checkout__select--label" for="country">Country/region</label>
                                                    <select class="checkout__input--select__field border-radius-5" name="cust_b_country" id="country">
                                                    <?php
                                                        $statement = $pdo->prepare("SELECT * FROM tbl_country ORDER BY country_name ASC");
                                                        $statement->execute();
                                                        $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                                                        foreach ($result as $row) {
                                                            ?>
                                                            <option value="<?php echo $row['country_id']; ?>" <?php if($row['country_id'] == $_SESSION['customer']['cust_b_country']) {echo 'selected';} ?>><?php echo $row['country_name']; ?></option>
                                                            <?php
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Address
                                                    <textarea class="contact__form--textarea" name="cust_b_address" placeholder="Apartment, suite, etc."><?php echo $_SESSION['customer']['cust_b_address']; ?></textarea>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                        <h3 class="section__header--title mb-5"> <?php echo LANG_VALUE_87; ?></h3>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Postal Code
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_zip" id="shipping_pincode" placeholder="Postal code" value="<?php echo $_SESSION['customer']['cust_s_zip']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>City
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_city" id="shipping_city" placeholder="City" value="<?php echo $_SESSION['customer']['cust_s_city']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>State
                                                        <input class="checkout__input--field border-radius-5" name="cust_s_state" id="shipping_state" placeholder="State" value="<?php echo $_SESSION['customer']['cust_s_state']; ?>" type="text">
                                                    </label>
                                                </div>
                                            </div>
                                           
                                            <div class="col-lg-12 mb-12">
                                                <div class="checkout__input--list checkout__input--select select">
                                                    <label class="checkout__select--label" for="country">Country/region</label>
                                                    <select class="checkout__input--select__field border-radius-5" name="cust_s_country" >
                                                    <?php
                                                        $statement = $pdo->prepare("SELECT * FROM tbl_country ORDER BY country_name ASC");
                                                        $statement->execute();
                                                        $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                                                        foreach ($result as $row) {
                                                            ?>
                                                            <option value="<?php echo $row['country_id']; ?>" <?php if($row['country_id'] == $_SESSION['customer']['cust_s_country']) {echo 'selected';} ?>><?php echo $row['country_name']; ?></option>
                                                            <?php
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 mb-12">
                                                <div class="checkout__input--list">
                                                    <label>Address
                                                    <textarea class="contact__form--textarea" name="cust_s_address" placeholder="Apartment, suite, etc."><?php echo $_SESSION['customer']['cust_s_address']; ?></textarea>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mb-12">
                                        <input type="submit" class="account__login--btn primary__btn mb-10" value="<?php echo LANG_VALUE_5; ?>" name="form1">
                                        </div>
                                    </form>
                                    </div>
                                </div>
                            </div>
                           

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- my account section end -->
         
<?php include('include/footer.php')?>
<script>
     document.getElementById('pincode').addEventListener('input', function () {
    const pincode = this.value.trim();

    if (pincode.length === 6) {
        fetch(`https://api.postalpincode.in/pincode/${pincode}`)
            .then(response => response.json())
            .then(data => {
                if (Array.isArray(data) && data[0].Status === "Success") {
                    const postOffice = data[0].PostOffice[0];
                    document.getElementById('city').value = postOffice.District || '';
                    document.getElementById('state').value = postOffice.State || '';
                } else {
                    alert('Invalid pincode or no details found.');
                }
            })
            .catch(error => console.error('Error fetching address details:', error));
    }
});
     document.getElementById('shipping_pincode').addEventListener('input', function () {
    const pincode = this.value.trim();

    if (pincode.length === 6) {
        fetch(`https://api.postalpincode.in/pincode/${pincode}`)
            .then(response => response.json())
            .then(data => {
                if (Array.isArray(data) && data[0].Status === "Success") {
                    const postOffice = data[0].PostOffice[0];
                    document.getElementById('shipping_city').value = postOffice.District || '';
                    document.getElementById('shipping_state').value = postOffice.State || '';
                } else {
                    alert('Invalid pincode or no details found.');
                }
            })
            .catch(error => console.error('Error fetching address details:', error));
    }
});
</script>
</body>

</html>