<?php 
include('include/header.php');

// Check if the customer is logged in or not
if(!isset($_SESSION['customer'])) {
    header('location: '.BASE_URL.'logout.php');
    exit;
} else {
    // If customer is logged in, but admin make him inactive, then force logout this user.
    $statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=? AND cust_status=?");
    $statement->execute(array($_SESSION['customer']['cust_id'], 0));
    $total = $statement->rowCount();
    if($total) {
        header('location: '.BASE_URL.'logout.php');
        exit;
    }
}

// Check if payment_id is passed
if(isset($_GET['payment_id']) && !empty($_GET['payment_id'])) {
    $payment_id = $_GET['payment_id'];

    // Fetch order details using payment_id
    $statement = $pdo->prepare("SELECT * FROM tbl_payment WHERE payment_id=? AND customer_email=?");
    $statement->execute(array($payment_id, $_SESSION['customer']['cust_email']));
    $order = $statement->fetch(PDO::FETCH_ASSOC);

    // Check if the order exists
    if(!$order) {
        echo "Order not found or you're not authorized to view this order.";
        exit;
    }

    // Fetch order products based on payment_id
    $statement1 = $pdo->prepare("SELECT * FROM tbl_order WHERE payment_id=?");
    $statement1->execute(array($payment_id));
    $order_items = $statement1->fetchAll(PDO::FETCH_ASSOC);
    
    // Fetch customer details for addresses
   $statement2 = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id = ?");
    $statement2->execute(array($_SESSION['customer']['cust_id']));
    $customer_details = $statement2->fetch(PDO::FETCH_ASSOC);
} else {
    echo "Invalid order ID.";
    exit;
}
?>

 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">My Account</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">My Account</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->

<!-- Start Order Detail Section -->
<section class="order__detail--section section--padding bg-light">
    <div class="container">
        <div class="order__detail--wrapper bg-white rounded shadow-lg p-4">
            <h2 class="order__content--title h3 mb-4">Order #<?php echo $order['payment_id']; ?></h2>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <h5 class="text-muted">Payment Status:</h5>
                    <p class="font-weight-bold"><?php echo $order['payment_status']; ?></p>
                </div>
                <div class="col-md-6">
                    <h5 class="text-muted">Payment Date:</h5>
                    <p class="font-weight-bold"><?php echo $order['payment_date']; ?></p>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <h5 class="text-muted">Payment Method:</h5>
                    <p class="font-weight-bold"><?php echo $order['payment_method']; ?></p>
                </div>
                <div class="col-md-6">
                    <h5 class="text-muted">Total Amount:</h5>
                    <p class="font-weight-bold text-success">₹<?php echo $order['paid_amount']; ?></p>
                </div>
            </div>
            
             <div class="row mb-3">
                  <h4 class=" mb-3">Address Details</h4>
               <?php if (!empty($customer_details['cust_b_landmark'])): ?>
                <div class="col-md-6">
                    <h5 class="text-muted">Landmark:</h5>
                    <p class="font-weight-bold"><?php echo htmlspecialchars($customer_details['cust_b_landmark']); ?>,</p>
                </div>
                <?php endif; ?>
                <div class="col-md-6">
                    <h5 class="text-muted">Shipping Address:</h5>
                    <p class="font-weight-bold"><?php echo $customer_details['cust_b_address']; ?></p>
                </div>
                <?php if (!empty($customer_details['cust_b_address_two'])): ?>
                <div class="col-md-6">
                    <h5 class="text-muted">Second Address:</h5>
                    <p class="font-weight-bold"><?php echo htmlspecialchars($customer_details['cust_b_address_two']); ?></p>
                </div>
                <?php endif; ?>
                <div class="col-md-6">
                    <h5 class="text-muted">Billing Address:</h5>
                    <p class="font-weight-bold"><?php echo nl2br($customer_details['cust_s_address']); ?></p>
                </div>
            </div>

            <!-- Display Order Items -->
            <div class="order__items--area mb-4">
                <h4 class=" mb-3">Ordered Products</h4>
                <table class="table table-striped table-bordered">
                    <thead class="thead-dark">
                        <tr>
                            <th>Product Name</th>
                            <th>Size</th>
                            <th>Color</th>
                            <th>Quantity</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($order_items as $item): ?>
                        <tr>
                        <td>
                            <?php echo $item['product_name']; ?>
                             <?php 
                            if (!empty($item['custom_image'])) {
                                echo '<a href="' . htmlspecialchars($item['custom_image']) . '" target="_blank">';
                                echo '<img src="' . htmlspecialchars($item['custom_image']) . '" alt="' . htmlspecialchars($item['product_name']) . '" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">';
                                echo '</a>';
                            }
                            ?>
                            <?php 
                            if (!empty($item['logo_image'])) {
                                echo '<a href="' . htmlspecialchars($item['logo_image']) . '" target="_blank">';
                                echo '<img src="' . htmlspecialchars($item['logo_image']) . '" alt="' . htmlspecialchars($item['product_name']) . '" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">';
                                echo '</a>';
                            }
                            ?>
                        </td>
                            <td><?php echo $item['size']; ?></td>
                            <td><?php echo $item['color']; ?></td>
                            <td><?php echo $item['quantity']; ?></td>
                            <td>₹<?php echo $item['unit_price']*$item['quantity']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($order['invoice_path'])): ?>
            <a href="<?php echo $order['invoice_path']; ?>" class="account__details--footer__btn">Download Invoice</a>
            <?php endif; ?>
            <a href="customer-order.php" class="account__details--footer__btn">Back to Orders</a>
        </div>
    </div>
</section>
<!-- End Order Detail Section -->

<?php include('include/footer.php') ?>
</body>
</html>
