<?php include('include/header.php')?>
<?php
// Check if the customer is logged in or not
if(!isset($_SESSION['customer'])) {
    header('location: '.BASE_URL.'logout.php');
    exit;
} else {
    // If customer is logged in, but admin make him inactive, then force logout this user.
    $statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=? AND cust_status=?");
    $statement->execute(array($_SESSION['customer']['cust_id'],0));
    $total = $statement->rowCount();
    if($total) {
        header('location: '.BASE_URL.'logout.php');
        exit;
    }
}
?>

 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">My Account</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">My Account</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->

         <!-- my account section start -->
         <section class="my__account--section section--padding">
            <div class="container">
                <div class="my__account--section__inner border-radius-10 d-flex">
                    <div class="account__left--sidebar">
                        <h2 class="account__content--title h3 mb-20">My Profile</h2>
                        <ul class="account__menu">
                        <?php require_once('customer-sidebar.php'); ?>
                        </ul>
                    </div>
                    <div class="account__wrapper">
                        <div class="account__content">
                            <!-- <h2 class="account__content--title h3 mb-20">Orders History</h2>-->
                            
                            <div class="checkout__content--step section__shipping--address pt-10">
                                <div class="section__header mb-25">
                                    <h3 class="section__header--title"> <?php echo LANG_VALUE_25; ?></h3>
                                </div>

                                <div class="account__table--area">
                                <table class="account__table">
                                    <thead class="account__table--header">
                                        <tr class="account__table--header__child">
                                            <th class="account__table--header__child--items"><?php echo '#' ?></th>
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_48; ?></th>
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_27; ?></th>
                                            <!-- <th class="account__table--header__child--items"><?php echo LANG_VALUE_28; ?></th> -->
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_29; ?></th>	 	 	 	
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_30; ?></th>	 	 	 	
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_31; ?></th>	 	 	 	
                                            <th class="account__table--header__child--items"><?php echo LANG_VALUE_32; ?></th>	 	 	 	
                                        </tr>
                                    </thead>
                                    <tbody class="account__table--body mobile__none">
                                    <?php
/* ===================== Pagination Code Starts ================== */
$adjacents = 5;

$statement = $pdo->prepare("SELECT * FROM tbl_payment WHERE customer_email=? ORDER BY id DESC");
$statement->execute(array($_SESSION['customer']['cust_email']));
$total_pages = $statement->rowCount();

$targetpage = BASE_URL.'customer-order.php';
$limit = 10;
$page = @$_GET['page'];
$start = ($page) ? ($page - 1) * $limit : 0;

$statement = $pdo->prepare("SELECT * FROM tbl_payment WHERE customer_email=? ORDER BY id DESC LIMIT $start, $limit");
$statement->execute(array($_SESSION['customer']['cust_email']));
$result = $statement->fetchAll(PDO::FETCH_ASSOC);

if ($page == 0) $page = 1;
$prev = $page - 1;
$next = $page + 1;
$lastpage = ceil($total_pages / $limit);
$lpm1 = $lastpage - 1;

$pagination = "";
if ($lastpage > 1) {   
    $pagination .= "<div class=\"pagination d-flex justify-content-center gap-2 mt-4\">";
    
    // Previous button
    if ($page > 1) 
        $pagination .= "<a class='btn btn-primary btn-md' href=\"$targetpage?page=$prev\">&#171; Previous</a>";
    else
        $pagination .= "<span class=\"btn btn-secondary btn-md disabled\">&#171; Previous</span>";

    // Page numbers
    if ($lastpage < 7 + ($adjacents * 2)) {   
        for ($counter = 1; $counter <= $lastpage; $counter++) {
            if ($counter == $page)
                $pagination .= "<span class=\"btn btn-success btn-md active\">$counter</span>";
            else
                $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$counter\">$counter</a>";
        }
    } elseif ($lastpage > 5 + ($adjacents * 2)) {
        if ($page < 1 + ($adjacents * 2)) {        
            for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++) {
                if ($counter == $page)
                    $pagination .= "<span class=\"btn btn-success btn-md active\">$counter</span>";
                else
                    $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$counter\">$counter</a>";
            }
            $pagination .= "<span class='btn btn-secondary btn-md disabled'>...</span>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$lpm1\">$lpm1</a>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$lastpage\">$lastpage</a>";
        } elseif ($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2)) {
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=1\">1</a>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=2\">2</a>";
            $pagination .= "<span class='btn btn-secondary btn-md disabled'>...</span>";
            for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++) {
                if ($counter == $page)
                    $pagination .= "<span class=\"btn btn-success btn-md active\">$counter</span>";
                else
                    $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$counter\">$counter</a>";
            }
            $pagination .= "<span class='btn btn-secondary btn-md disabled'>...</span>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$lpm1\">$lpm1</a>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$lastpage\">$lastpage</a>";
        } else {
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=1\">1</a>";
            $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=2\">2</a>";
            $pagination .= "<span class='btn btn-secondary btn-md disabled'>...</span>";
            for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++) {
                if ($counter == $page)
                    $pagination .= "<span class=\"btn btn-success btn-md active\">$counter</span>";
                else
                    $pagination .= "<a class='btn btn-outline-primary btn-md' href=\"$targetpage?page=$counter\">$counter</a>";
            }
        }
    }

    // Next button
    if ($page < $counter - 1) 
        $pagination .= "<a class='btn btn-primary btn-md' href=\"$targetpage?page=$next\">Next &#187;</a>";
    else
        $pagination .= "<span class=\"btn btn-secondary btn-md disabled\">Next &#187;</span>";
    
    $pagination .= "</div>\n";       
}
?>

            <?php
                                $tip = $page*10-10;
                                foreach ($result as $row) {
                                    $tip++;
                                    ?>
                                        <tr class="account__table--body__child">
                                            <td class="account__table--body__child--items"><?php echo $tip; ?></td>
                                            <td class="account__table--body__child--items text-small"> <?php
                                            $statement1 = $pdo->prepare("SELECT * FROM tbl_order WHERE payment_id=?");
                                            $statement1->execute(array($row['payment_id']));
                                            $result1 = $statement1->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($result1 as $row1) {
                                                echo '<strong>'.$row1['product_name'].'</strong>';
                                                echo '<br><br>';
                                            }
                                            ?></td>
                                            <td class="account__table--body__child--items"><?php echo $row['payment_date']; ?></td>
                                            <!-- <td class="account__table--body__child--items"><?php echo $row['txnid']; ?></td> -->
                                            <td class="account__table--body__child--items"><?php echo '₹'.$row['paid_amount']; ?></td>
                                            <td class="account__table--body__child--items"><?php echo $row['payment_status']; ?></td>
                                            <td class="account__table--body__child--items"><?php echo $row['payment_method']; ?></td>
                                            <td class="account__table--body__child--items"><?php echo $row['payment_id']; ?></td>
                                            <td class="account__table--body__child--items">
                                                <a href="customer-order-detail.php?payment_id=<?php echo $row['payment_id']; ?>" class="account__details--footer__btn">View</a>
                                            </td>
                                        </tr>
                                        <?php
                                } 
                                ?> 
                                    </tbody>
                                </table>
                                <div class="pagination" style="overflow: hidden;">
                        <?php 
                            echo $pagination; 
                        ?>
                            </div> 
                            </div>
                           

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- my account section end -->
         
<?php include('include/footer.php')?>
</body>

</html>