<?php include('include/header.php')?>
<?php
// Check if the customer is logged in or not
if(!isset($_SESSION['customer'])) {
    header('location: '.BASE_URL.'logout.php');
    exit;
} else {
    // If customer is logged in, but admin make him inactive, then force logout this user.
    $statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=? AND cust_status=?");
    $statement->execute(array($_SESSION['customer']['cust_id'],0));
    $total = $statement->rowCount();
    if($total) {
        header('location: '.BASE_URL.'logout.php');
        exit;
    }
}
?>
<?php
if (isset($_POST['form1'])) {

    $valid = 1;

    if( empty($_POST['cust_password']) || empty($_POST['cust_re_password']) ) {
        $valid = 0;
        $error_message .= LANG_VALUE_138."<br>";
    }

    if( !empty($_POST['cust_password']) && !empty($_POST['cust_re_password']) ) {
        if($_POST['cust_password'] != $_POST['cust_re_password']) {
            $valid = 0;
            $error_message .= LANG_VALUE_139."<br>";
        }
    }
    
    if($valid == 1) {

        // update data into the database

        $password = strip_tags($_POST['cust_password']);
        
        $statement = $pdo->prepare("UPDATE tbl_customer SET cust_password=? WHERE cust_id=?");
        $statement->execute(array(md5($password),$_SESSION['customer']['cust_id']));
        
        $_SESSION['customer']['cust_password'] = md5($password);        

        $success_message = LANG_VALUE_141;
    }
}
?>
 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">My Account</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">My Account</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->

         <!-- my account section start -->
         <section class="my__account--section section--padding">
            <div class="container">
                <div class="my__account--section__inner border-radius-10 d-flex">
                    <div class="account__left--sidebar">
                        <h2 class="account__content--title h3 mb-20">My Profile</h2>
                        <ul class="account__menu">
                        <?php require_once('customer-sidebar.php'); ?>
                        </ul>
                    </div>
                    <div class="account__wrapper">
                        <div class="account__content">
                            <!-- <h2 class="account__content--title h3 mb-20">Orders History</h2>-->
                            
                            <div class="checkout__content--step section__shipping--address pt-10">
                                <div class="section__header mb-25">
                                    <h3 class="section__header--title"> <?php echo LANG_VALUE_99; ?></h3>
                                    <?php
                                        if($error_message != '') {
                                            echo "<p class='section__header--desc text-danger error' style='padding: 10px;background:#f1f1f1;margin-bottom:20px;'>".$error_message."</p>";
                                        }
                                        if($success_message != '') {
                                            echo "<p class='section__header--desc text-success success' style='padding: 10px;background:#f1f1f1;margin-bottom:20px;'>".$success_message."</p>";
                                        }
                                        ?>
                                </div>

                                <div class="checkout__content--step__inner3 border-radius-5">
                                    <div class="checkout__content--input__box--wrapper ">
                                    <form action="" method="post">
                                    <?php $csrf->echoInputField(); ?>
                                        <div class="row">
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list ">
                                                    <label><?php echo LANG_VALUE_100; ?> *
                                                        <input class="checkout__input--field border-radius-5" name="cust_password" placeholder="password"  type="password">
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-12">
                                                <div class="checkout__input--list ">
                                                    <label><?php echo LANG_VALUE_101; ?> *
                                                        <input class="checkout__input--field border-radius-5" name="cust_re_password" placeholder="password"  type="password">
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="col-lg-12 mb-12">
                                            <input type="submit" class="account__login--btn primary__btn mb-10" value="<?php echo LANG_VALUE_5; ?>" name="form1">
                                        </div>
                                        </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                           

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- my account section end -->
         
<?php include('include/footer.php')?>
</body>

</html>