<?php include('include/header.php')?>
<?php
// Check if the customer is logged in or not
if(!isset($_SESSION['customer'])) {
    header('location: '.BASE_URL.'logout.php');
    exit;
} else {
    // If customer is logged in, but admin make him inactive, then force logout this user.
    $statement = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_id=? AND cust_status=?");
    $statement->execute(array($_SESSION['customer']['cust_id'],0));
    $total = $statement->rowCount();
    if($total) {
        header('location: '.BASE_URL.'logout.php');
        exit;
    }
}
?>
 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">My Account</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">My Account</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->

         <!-- my account section start -->
         <section class="my__account--section section--padding">
            <div class="container">
                <div class="my__account--section__inner border-radius-10 d-flex">
                    <div class="account__left--sidebar">
                        <h2 class="account__content--title h3 mb-20">My Profile</h2>
                        <ul class="account__menu">
                        <?php require_once('customer-sidebar.php'); ?>
                        </ul>
                    </div>
                    <div class="account__wrapper">
                        <div class="account__content">
                           <!-- Customer Info Section -->
                            <div class="row">
                                <!-- Customer Info Card -->
                                <div class="col-md-8 col-lg-6">
                                    <div class="card rounded-3 border-0">
                                        <div class="card-header bg-gradient-primary p-4 rounded-top">
                                            <h5 class="mb-0"><i class="fas fa-user-circle"></i> Your Account Details</h5>
                                        </div>
                                        <div class="card-body p-4">
                                            <div class="account__details">
                                                <div class="row mb-3">
                                                    <div class="col-12">
                                                        <p class="font-weight-bold text-muted">Name: <?php echo $_SESSION['customer']['cust_b_name']; ?></p>
                                                    </div>
                                                </div>
                                                <div class="row mb-3">
                                                    <div class="col-12">
                                                        <p class="font-weight-bold text-muted">Company Name: <?php echo $_SESSION['customer']['cust_b_cname']; ?></p>
                                                    </div>
                                                </div>
                                                <div class="row mb-3">
                                                    <div class="col-12">
                                                        <p class="font-weight-bold text-muted">Phone: <?php echo $_SESSION['customer']['cust_b_phone']; ?></p>
                                                    </div>
                                                </div>
                                                <div class="row mb-3">
                                                    <div class="col-12">
                                                        <p class="font-weight-bold text-muted">Email: <?php echo $_SESSION['customer']['cust_email']; ?></p>
                                                    </div>
                                                </div>
                                                 <div class="account__details--footer d-flex">
                                                    <a href="customer-profile-update.php" class="account__details--footer__btn" type="button">Edit</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                           

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- my account section end -->
         
<?php include('include/footer.php')?>
</body>

</html>