<?php
session_start();
require_once('../../admin/inc/config.php');

$razorpay_key = 'rzp_live_ZsfcHOE1qBZL0x';
$razorpay_secret = 'NUMelK33P0bZmpDfPMRK4JWA';

// Capture Razorpay details from POST request
$razorpay_payment_id = isset($_POST['razorpay_payment_id']) ? $_POST['razorpay_payment_id'] : '';
$razorpay_order_id = isset($_POST['razorpay_order_id']) ? $_POST['razorpay_order_id'] : '';
$razorpay_signature = isset($_POST['razorpay_signature']) ? $_POST['razorpay_signature'] : '';

if (empty($razorpay_payment_id) || empty($razorpay_order_id) || empty($razorpay_signature)) {
    echo json_encode(['success' => false, 'error' => 'Incomplete payment data.']);
    exit();
}

// Verify Razorpay Payment Signature
function verifySignature($order_id, $payment_id, $signature, $secret) {
    $generated_signature = hash_hmac('sha256', $order_id . "|" . $payment_id, $secret);
    return ($generated_signature === $signature);
}

try {
    // Verify the payment signature first
    $is_valid = verifySignature($razorpay_order_id, $razorpay_payment_id, $razorpay_signature, $razorpay_secret);
    if (!$is_valid) {
        throw new Exception('Signature verification failed.');
    }

    // Verify the payment status using Razorpay API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.razorpay.com/v1/payments/$razorpay_payment_id");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, $razorpay_key . ":" . $razorpay_secret);
    curl_setopt($ch, CURLOPT_HTTPGET, true);

    $apiResponse = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new Exception('Curl error during payment verification: ' . curl_error($ch));
    }

    $response_data = json_decode($apiResponse, true);
    curl_close($ch);

    // Check if the payment status is 'captured'
    if (!isset($response_data['status']) || $response_data['status'] !== 'captured') {
        throw new Exception('Payment not captured.');
    }

    // Ensure payment session exists
    if (!isset($_SESSION['payment_id'])) {
        throw new Exception('Payment session not found.');
    }

    $payment_id_session = $_SESSION['payment_id'];

    // Update payment status in database
    $stmt = $pdo->prepare("UPDATE tbl_payment SET payment_status = ?, txnid = ? WHERE payment_id = ?");
    $stmt->execute(['Success', $razorpay_payment_id, $payment_id_session]);

    // Ensure cart data is present in session
    if (!isset($_SESSION['cart_p_id']) || !is_array($_SESSION['cart_p_id'])) {
        throw new Exception('Cart is empty.');
    }

    $orderDetails = '';
    $total_amount = 0;

    // Loop through cart items to insert them into the orders table
    foreach ($_SESSION['cart_p_id'] as $key => $product_id) {
        // Fetch product details from session
        $product_name = $_SESSION['cart_p_name'][$key] ?? '';
        $size = $_SESSION['cart_size_name'][$key] ?? '';
        $color = $_SESSION['cart_color_name'][$key] ?? '';
        $quantity = $_SESSION['cart_p_qty'][$key] ?? 0;
        $unit_price = $_SESSION['cart_p_current_price'][$key] ?? 0;

        // Fetch customization details from session
        $custom_image = isset($_SESSION['customizations'][$_SESSION['cart_p_customization'][$key]]) 
            ? $_SESSION['customizations'][$_SESSION['cart_p_customization'][$key]]['custom_image'] 
            : NULL;
        $logo_image = isset($_SESSION['customizations'][$_SESSION['cart_p_customization'][$key]]) 
            ? $_SESSION['customizations'][$_SESSION['cart_p_customization'][$key]]['logo'] 
            : NULL;

        // Insert order details into the database
        $orderStmt = $pdo->prepare("INSERT INTO tbl_order (
            product_id, product_name, size, color, quantity, unit_price, payment_id, custom_image, logo_image
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $orderStmt->execute([ 
            $product_id,
            $product_name,
            $size,
            $color,
            $quantity,
            $unit_price,
            $payment_id_session,
            $custom_image,
            $logo_image 
        ]);

        // Accumulate order details for email
        $orderDetails .= "Product: $product_name\nSize: $size\nColor: $color\nQuantity: $quantity\nUnit Price: $unit_price\n\n";
        $total_amount += $unit_price * $quantity;
    }

    // Clear session data after successful order processing
    unset($_SESSION['cart_p_id'], $_SESSION['cart_size_id'], $_SESSION['cart_size_name']);
    unset($_SESSION['cart_color_id'], $_SESSION['cart_color_name'], $_SESSION['cart_p_qty']);
    unset($_SESSION['cart_p_current_price'], $_SESSION['cart_p_name'], $_SESSION['cart_p_featured_photo']);
    unset($_SESSION['payment_id'], $_SESSION['razorpay_order_id']);
    unset($_SESSION['cart_p_customization'], $_SESSION['customizations']);

     // Send confirmation email to the customer (commented out)
    
    $customer_email = "arkcorporateuniforms@gmail.com";
    $subject = "New Order Received - Order Details";
    $message = "A new order has been received!\n\nHere are the details of the order:\n\n" . $orderDetails . "\nTotal Amount: $total_amount\n\nPlease process the order and prepare for shipment.\n\nThank you for your prompt attention to this order!";
    $headers = "From: no-reply@corporateuniforms.co.in";

    if (mail($customer_email, $subject, $message, $headers)) {}
    

    echo "
    <script type='text/javascript'>
        window.onload = function() {
            window.location.href = '../../payment_success.php'; 
        };
    </script>
    ";

} catch (Exception $e) {
    error_log('Payment verification error: ' . $e->getMessage());

    echo "<script>
            alert('Payment Verification Failed: " . addslashes($e->getMessage()) . "');
            window.location.href = '../../checkout.php'; // Redirect back to checkout page
          </script>";
    exit();
}
