<?php include('include/header.php')?>
<?php
if(!isset($_REQUEST['id'])) {
    header('location: index.php');
    exit;
} else {
    // Check the id is valid or not
    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE p_id=?");
    $statement->execute(array($_REQUEST['id']));
    $total = $statement->rowCount();
    $result = $statement->fetchAll(PDO::FETCH_ASSOC);
    if( $total == 0 ) {
        header('location: index.php');
        exit;
    }
}

foreach($result as $row) {
    $p_name = $row['p_name'];
    $p_old_price = $row['p_old_price'];
    $p_current_price = $row['p_current_price'];
    $p_qty = $row['p_qty'];
    $p_sku = $row['p_sku'];
    $p_hsn = $row['p_hsn'];
    $p_unit = $row['p_unit'];
    $p_featured_photo = $row['p_featured_photo'];
    $p_description = $row['p_description'];
    $p_short_description = $row['p_short_description'];
    $p_feature = $row['p_feature'];
    $p_condition = $row['p_condition'];
    $p_return_policy = $row['p_return_policy'];
    $p_total_view = $row['p_total_view'];
    $p_is_featured = $row['p_is_featured'];
    $p_is_active = $row['p_is_active'];
    $ecat_id = $row['ecat_id'];
    $productId = $row['p_id'];
    $p_is_custom = $row['p_is_custom'];
}

// Getting all categories name for breadcrumb
$statement = $pdo->prepare("SELECT
                        t1.ecat_id,
                        t1.ecat_name,
                        t1.mcat_id,

                        t2.mcat_id,
                        t2.mcat_name,
                        t2.tcat_id,

                        t3.tcat_id,
                        t3.tcat_name

                        FROM tbl_end_category t1
                        JOIN tbl_mid_category t2
                        ON t1.mcat_id = t2.mcat_id
                        JOIN tbl_top_category t3
                        ON t2.tcat_id = t3.tcat_id
                        WHERE t1.ecat_id=?");
$statement->execute(array($ecat_id));
$total = $statement->rowCount();
$result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
foreach ($result as $row) {
    $ecat_name = $row['ecat_name'];
    $mcat_id = $row['mcat_id'];
    $mcat_name = $row['mcat_name'];
    $tcat_id = $row['tcat_id'];
    $tcat_name = $row['tcat_name'];
}


$p_total_view = $p_total_view + 1;

$statement = $pdo->prepare("UPDATE tbl_product SET p_total_view=? WHERE p_id=?");
$statement->execute(array($p_total_view,$_REQUEST['id']));


$statement = $pdo->prepare("SELECT * FROM tbl_product_size WHERE p_id=?");
$statement->execute(array($_REQUEST['id']));
$result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
foreach ($result as $row) {
    $size[] = $row['size_id'];
}

$statement = $pdo->prepare("SELECT * FROM tbl_product_color WHERE p_id=?");
$statement->execute(array($_REQUEST['id']));
$result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
foreach ($result as $row) {
    $color[] = $row['color_id'];
}


if(isset($_POST['form_review'])) {
    
    $statement = $pdo->prepare("SELECT * FROM tbl_rating WHERE p_id=? AND cust_id=?");
    $statement->execute(array($_REQUEST['id'],$_SESSION['customer']['cust_id']));
    $total = $statement->rowCount();
    
    if($total) {
        $error_message = LANG_VALUE_68; 
    } else {
        $statement = $pdo->prepare("INSERT INTO tbl_rating (p_id,cust_id,comment,rating) VALUES (?,?,?,?)");
        $statement->execute(array($_REQUEST['id'],$_SESSION['customer']['cust_id'],$_POST['comment'],$_POST['rating']));
        $success_message = LANG_VALUE_163;    
    }
    
}

// Getting the average rating for this product
$t_rating = 0;
$statement = $pdo->prepare("SELECT * FROM tbl_rating WHERE p_id=?");
$statement->execute(array($_REQUEST['id']));
$tot_rating = $statement->rowCount();
if($tot_rating == 0) {
    $avg_rating = 0;
} else {
    $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
    foreach ($result as $row) {
        $t_rating = $t_rating + $row['rating'];
    }
    $avg_rating = $t_rating / $tot_rating;
}
$uniqueid1 = uniqid();
if (isset($_COOKIE['customize_id'])) {
    $uniqueid = $_COOKIE['customize_id'];
}else{
    $uniqueid = uniqid();
}
if(isset($_POST['form_add_to_cart'])) {
    
    // getting the current stock of this product
    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE p_id=?");
    $statement->execute(array($_REQUEST['id']));
    $result = $statement->fetchAll(PDO::FETCH_ASSOC);							
    foreach ($result as $row) {
        $current_p_qty = $row['p_qty'];
    }
    if($_POST['p_qty'] > $current_p_qty):
        $temp_msg = 'Sorry! There are only '.$current_p_qty.' item(s) in stock';
        ?>
        <script type="text/javascript">alert('<?php echo $temp_msg; ?>');</script>
        <?php
    else:
        if(isset($_SESSION['cart_p_id'])) {
            $arr_cart_p_id = array();
            $arr_cart_size_id = array();
            $arr_cart_color_id = array();
            $arr_cart_p_qty = array();
            $arr_cart_p_current_price = array();
            $arr_cart_p_customization = array(); // New array for customization

            $i=0;
            foreach($_SESSION['cart_p_id'] as $key => $value) {
                $i++;
                $arr_cart_p_id[$i] = $value;
            }

            $i=0;
            foreach($_SESSION['cart_size_id'] as $key => $value) {
                $i++;
                $arr_cart_size_id[$i] = $value;
            }

            $i=0;
            foreach($_SESSION['cart_color_id'] as $key => $value) {
                $i++;
                $arr_cart_color_id[$i] = $value;
            }

            $i=0;
            foreach($_SESSION['cart_p_customization'] as $key => $value) {
                $i++;
                $arr_cart_p_customization[$i] = $value;
            }

            $added = 0;
            if(!isset($_POST['size_id'])) {
                $size_id = 0;
            } else {
                $size_id = $_POST['size_id'];
            }
            if(!isset($_POST['color_id'])) {
                $color_id = 0;
            } else {
                $color_id = $_POST['color_id'];
            }

            // Get customization data
         

            // Product is considered unique if it has a different customization
            $added = 0;

            // Add the product with its customization
            $i=0;
            foreach($_SESSION['cart_p_id'] as $key => $res) {
                $i++;
            }
            $new_key = $i+1;

            if(isset($_POST['size_id'])) {
                $size_id = $_POST['size_id'];
                $statement = $pdo->prepare("SELECT * FROM tbl_size WHERE size_id=?");
                $statement->execute(array($size_id));
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    $size_name = $row['size_name'];
                }
            } else {
                $size_id = 0;
                $size_name = '';
            }
            
            if(isset($_POST['color_id'])) {
                $color_id = $_POST['color_id'];
                $statement = $pdo->prepare("SELECT * FROM tbl_color WHERE color_id=?");
                $statement->execute(array($color_id));
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    $color_name = $row['color_name'];
                }
            } else {
                $color_id = 0;
                $color_name = '';
            }

            $_SESSION['cart_p_id'][$new_key] = $_REQUEST['id'];
            $_SESSION['cart_size_id'][$new_key] = $size_id;
            $_SESSION['cart_size_name'][$new_key] = $size_name;
            $_SESSION['cart_color_id'][$new_key] = $color_id;
            $_SESSION['cart_color_name'][$new_key] = $color_name;
            $_SESSION['cart_p_qty'][$new_key] = $_POST['p_qty'];
            $_SESSION['cart_p_current_price'][$new_key] = $_POST['p_current_price'];
            $_SESSION['cart_p_name'][$new_key] = $_POST['p_name'];
            // $_SESSION['cart_p_hsn'][$new_key] = $_POST['p_hsn'];
            $_SESSION['cart_p_featured_photo'][$new_key] = $_POST['p_featured_photo'];
            $_SESSION['cart_p_customization'][$new_key] = $uniqueid; // Store customization ID

            $success_message1 = 'Product is added to the cart successfully!';
        } else {
            if(isset($_POST['size_id'])) {
                $size_id = $_POST['size_id'];
                $statement = $pdo->prepare("SELECT * FROM tbl_size WHERE size_id=?");
                $statement->execute(array($size_id));
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    $size_name = $row['size_name'];
                }
            } else {
                $size_id = 0;
                $size_name = '';
            }
            
            if(isset($_POST['color_id'])) {
                $color_id = $_POST['color_id'];
                $statement = $pdo->prepare("SELECT * FROM tbl_color WHERE color_id=?");
                $statement->execute(array($color_id));
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    $color_name = $row['color_name'];
                }
            } else {
                $color_id = 0;
                $color_name = '';
            }

            

            $_SESSION['cart_p_id'][1] = $_REQUEST['id'];
            $_SESSION['cart_size_id'][1] = $size_id;
            $_SESSION['cart_size_name'][1] = $size_name;
            $_SESSION['cart_color_id'][1] = $color_id;
            $_SESSION['cart_color_name'][1] = $color_name;
            $_SESSION['cart_p_qty'][1] = $_POST['p_qty'];
            $_SESSION['cart_p_current_price'][1] = $_POST['p_current_price'];
            $_SESSION['cart_p_name'][1] = $_POST['p_name'];
            // $_SESSION['cart_p_hsn'] = $_POST['p_hsn'];
            $_SESSION['cart_p_featured_photo'][1] = $_POST['p_featured_photo'];
            $_SESSION['cart_p_customization'][1] = $uniqueid;

            $success_message1 = 'Product is added to the cart successfully!';
        }

        echo "<script type='text/javascript'>alert('Product is added to the cart successfully!');
                window.location.href = 'cart.php';
        </script>";
    endif;
}
?>

<?php
if($error_message1 != '') {
    echo "<script>alert('".$error_message1."')</script>";
}
?>
<main class="main__content_wrapper">
    <input type="hidden" id="preloader">
 <!-- Start breadcrumb section -->
 <section class="breadcrumb__section breadcrumb__bg">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25"><?php echo $p_name; ?></h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="<?php echo BASE_URL; ?>">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="<?php echo BASE_URL.'product-category.php?id='.$tcat_id.'&type=top-category' ?>"><span class="text-white"><?php echo $tcat_name; ?></a></span></li>
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="<?php echo BASE_URL.'product-category.php?id='.$mcat_id.'&type=mid-category' ?>"><span class="text-white"><?php echo $mcat_name; ?></a></span></li>
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="<?php echo BASE_URL.'product-category.php?id='.$ecat_id.'&type=end-category' ?>"><span class="text-white"><?php echo $ecat_name; ?></a></span></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white"><?php echo $p_name; ?></span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End breadcrumb section -->
         <!-- Start product details section -->
        <section class="product__details--section section--padding">
            <div class="container">
                <div class="row row-cols-lg-2 row-cols-md-2">
                  <div class="col">
    <!-- Card left -->
    <div class="product-imgs">
        <div class="img-display">
            <div class="img-showcase">
                <?php
                // Fetch product photos from the database
                $statement = $pdo->prepare("SELECT * FROM tbl_product_photo WHERE p_id=?");
                $statement->execute([$_REQUEST['id']]);
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);

                // Initialize index for tracking images
                $index = 1;

                // Check if product photos are available
                if (!empty($result)) {
                    foreach ($result as $row) {
                        $zoomClass = ($index === 1) ? 'zoom-img' : ''; // Add zoom class to the first image
                        ?>
                        <img 
                            src="assets/uploads/product_photos/<?php echo htmlspecialchars($row['photo']); ?>" 
                            alt="Product Image" 
                            class="<?php echo $zoomClass; ?>" 
                            data-zoom="assets/uploads/product_photos/<?php echo htmlspecialchars($row['photo']); ?>" 
                            data-id="<?php echo $index; ?>" 
                            id="zoom-<?php echo $index; ?>">
                        <?php
                        $index++;
                    }
                } else {
                    // Show only the featured image if no other images are available
                    ?>
                    <img 
                        src="assets/uploads/<?php echo htmlspecialchars($p_featured_photo); ?>" 
                        alt="Default Product Image" 
                        class="zoom-img" 
                        data-zoom="assets/uploads/<?php echo htmlspecialchars($p_featured_photo); ?>" 
                        data-id="1" 
                        id="zoom-1">
                    <?php
                }
                ?>
            </div>
        </div>

        <div class="img-select">
            <?php
            // Display thumbnails if multiple images exist
            if (!empty($result)) {
                $index = 1;
                foreach ($result as $row) {
                    ?>
                    <div class="img-item">
                        <a href="#" data-id="<?php echo $index; ?>" class="thumbnail-img">
                            <img 
                                src="assets/uploads/product_photos/<?php echo htmlspecialchars($row['photo']); ?>" 
                                alt="Thumbnail Image">
                        </a>
                    </div>
                    <?php
                    $index++;
                }
            }
            ?>
        </div>
    </div>
</div>


            
                    <div class="col">
                        <div class="product__details--info">
                            <form action="" method="post">
                                <h2 class="product__details--info__title mb-15"><?php echo $p_name; ?></h2>
                                <div class="product__details--info__price mb-10">
                                    <span class="current__price">₹<?php echo $p_current_price; ?></span>
                                    <span class="price__divided"></span>
                                    <?php if($p_old_price!=''): ?>
                                    <span class="old__price">₹<?php echo $p_old_price; ?></span>
                                    <?php endif; ?>
                                </div>

                                <div class="product__details--info__rating d-flex align-items-center mb-15">
                                    <ul class="rating d-flex justify-content-center">
                                    <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                    </ul>
                                    <!-- <span class="product__items--rating__count--number">(24)</span> -->
                                </div>
                                <p class="product__details--info__desc mb-15"><?php echo $p_short_description; ?></p>
                                <div class="product__variant">
                                    <?php if(isset($size)): ?>
                                    <div class="col-md-12 mb_20 product__variant--title mb-8">
                                        <?php echo LANG_VALUE_52; ?> <br>
                                        <select name="size_id" class="variant__size--value red" style="width:auto;">
                                            <?php
                                            $statement = $pdo->prepare("SELECT * FROM tbl_size");
                                            $statement->execute();
                                            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($result as $row) {
                                                if(in_array($row['size_id'],$size)) {
                                                    ?>
                                                    <option value="<?php echo $row['size_id']; ?>"><?php echo $row['size_name']; ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <?php endif; ?>

                                    <?php if(isset($color)): ?>
                                    <div class="col-md-12 product__variant--title mb-8">
                                        <?php echo LANG_VALUE_53; ?> <br>
                                        <select name="color_id" class="variant__size--value red" style="width:auto;">
                                            <?php
                                            $statement = $pdo->prepare("SELECT * FROM tbl_color");
                                            $statement->execute();
                                            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($result as $row) {
                                                if(in_array($row['color_id'],$color)) {
                                                    ?>
                                                    <option value="<?php echo $row['color_id']; ?>"><?php echo $row['color_name']; ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <?php endif; ?>
                                    <input type="hidden" name="p_current_price" value="<?php echo $p_current_price; ?>">
                                    <input type="hidden" name="p_name" value="<?php echo $p_name; ?>">
                                     <input type="hidden" name="p_hsn" value="<?php echo $p_hsn; ?>">
                                    <input type="hidden" name="p_featured_photo" value="<?php echo $p_featured_photo; ?>">
                                   
                                    <div class="product__variant--list quantity mt-4 mb-20">
                                    <h4 class="mb-2">Number of Unit</h4>
                                    <div class="quantity__box">
                                                        <button type="button" class="quantity__value quickview__value--quantity decrease" aria-label="quantity value" value="Decrease Value">-</button>
                                                        <label>
                                                            <input readonly type="number" step="1" min="1" max="" name="p_qty" class="quantity__number quickview__value--number" pattern="[0-9]*" inputmode="numeric" value="1" data-counter/>
                                                        </label>
                                                        <button type="button" class="quantity__value quickview__value--quantity increase" aria-label="quantity value" value="Increase Value">+</button>
                                                    </div>   
                                    
                                        <!-- <button class="quickview__cart--btn primary__btn" type="submit">Add To Cart</button>   -->
                                    </div>
                                    <div class="product__variant--list mb-15">
                                        <!-- <a class="variant__wishlist--icon mb-15" href="wishlist.html" title="Add to wishlist">
                                            <svg class="quickview__variant--wishlist__svg" xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 512 512"><path d="M352.92 80C288 80 256 144 256 144s-32-64-96.92-64c-52.76 0-94.54 44.14-95.08 96.81-1.1 109.33 86.73 187.08 183 252.42a16 16 0 0018 0c96.26-65.34 184.09-143.09 183-252.42-.54-52.67-42.32-96.81-95.08-96.81z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/></svg>
                                            Add to Cart
                                        </a> -->
                                        <input type="submit" class="variant__buy--now__btn primary__btn" value="<?php echo LANG_VALUE_154; ?>" name="form_add_to_cart">
                                    </div>
                                      </form>
                                </div>
                                <button id="customizeButton" class="quickview__cart--btn primary__btn mt-3">Customize Product</button>
                              
                                    <div class="product__details--info__meta">
                                        <!-- <p class="product__details--info__meta--list"><strong>Barcode:</strong>  <span>565461</span> </p> -->
                                        <p class="product__details--info__meta--list"><strong>SKU Code:</strong>  <span><?php echo $p_sku ; ?></span> </p>
                                        <p class="product__details--info__meta--list"><strong>HSN Code:</strong>  <span><?php echo $p_hsn ; ?></span> </p>
                                        <p class="product__details--info__meta--list"><strong>Per Unit:</strong>  <span><?php echo $p_unit; ?> Pieces</span> </p>
                                        <p class="product__details--info__meta--list"><strong>Type:</strong>  <span><?php echo $tcat_name; ?></span> </p>
                                      
                                    </div>
                              
                                <div class="guarantee__safe--checkout mt-3">
                                    <h5 class="guarantee__safe--checkout__title">Guaranteed Safe Checkout</h5>
                                    <img class="guarantee__safe--checkout__img" src="assets/img/other/safe-checkout.png" alt="Payment Image">
                                </div>
                          <?php if ($p_is_custom == 1): ?>
                        <div class="customize-section">
                           
                            <div id="customizeModal" class="customize-modal">
                                <form action="" method="post">
                                 <div class="customize-modal-content">
                                    <span id="closeModal" class="close">&times;</span>
                                    <h3 class="modal-title">Customize Your Product</h3>
                                    <canvas id="tshirtCanvas" width="400" height="500" class="canvas-style"></canvas>
                                    <div class="content-m">
                                    <div class="upload-section">
                                        <label for="uploadLogo">Upload Logo:</label>
                                        <input type="file" id="uploadLogo" accept="image/*" class="upload-input">
                                    </div>
                                    <div class="actions">
                                        <button id="downloadBtn" class="account__details--footer__btn">Download</button>
                                        <button id="saveBtn" class="account__details--footer__btn secondary__btn">Save</button>
                                    </div>
                                    </div>
                                    <input type="hidden" id="productId" value="<?php echo $productId; ?>">
                                </div>
                                </form>
                            </div>
                        </div>
                         <?php endif; ?>
                        </div>
                       
                    </div>
                </div>
            </div>
        </section>
        <!-- End product details section -->

        <!-- Start product details tab section -->
        <section class="product__details--tab__section section--padding">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <ul class="product__details--tab d-flex mb-30">
                            <li class="product__details--tab__list active" data-toggle="tab" data-target="#description"><?php echo LANG_VALUE_59; ?></li>
                            <li class="product__details--tab__list" data-toggle="tab" data-target="#reviews"><?php echo LANG_VALUE_60; ?></li>
                            <li class="product__details--tab__list" data-toggle="tab" data-target="#information"><?php echo LANG_VALUE_61; ?></li>
                            <li class="product__details--tab__list" data-toggle="tab" data-target="#custom"><?php echo LANG_VALUE_62; ?></li>
                        </ul>
                        <div class="product__details--tab__inner border-radius-10">
                            <div class="tab_content">
                                <div id="description" class="tab_pane active show">
                                    <div class="product__tab--content">
                                    <?php
                                        if($p_description == '') {
                                            echo LANG_VALUE_70;
                                        } else {
                                            echo $p_description;
                                        }
                                        ?>
                                        
                                    </div> 
                                </div>
                                <div id="reviews" class="tab_pane">
                                    <div class="product__reviews">
                                    <?php
                                        if($p_feature == '') {
                                            echo LANG_VALUE_71;
                                        } else {
                                            echo $p_feature;
                                        }
                                        ?>
                                    </div>    
                                </div>
                                <div id="information" class="tab_pane">
                                    <div class="product__tab--conten">
                                    <?php
                                        if($p_condition == '') {
                                            echo LANG_VALUE_72;
                                        } else {
                                            echo $p_condition;
                                        }
                                        ?>
                                    </div> 
                                </div>
                                <div id="custom" class="tab_pane">
                                    <div class="product__tab--content">
                                    <?php
                                        if($p_return_policy == '') {
                                            echo LANG_VALUE_73;
                                        } else {
                                            echo $p_return_policy;
                                        }
                                        ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End product details tab section -->

         <!-- Start product section -->
         <section class="product__section product__section--style3 section--padding">
            <div class="container product3__section--container">
                <div class="section__heading text-center mb-50">
                    <h2 class="section__heading--maintitle"><?php echo LANG_VALUE_155; ?></h3>
                    <h3 class="section__heading text-muted"><?php echo LANG_VALUE_156; ?></h2>
                </div>
                <div class="product__section--inner product__swiper--column4__activation swiper">
                    <div class="swiper-wrapper">

                    
                    <?php
                    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE ecat_id=? AND p_id!=?");
                    $statement->execute(array($ecat_id,$_REQUEST['id']));
                    $result = $statement->fetchAll(PDO::FETCH_ASSOC);
                    foreach ($result as $row) {
                        ?>
                        <div class="swiper-slide">
                        <div class="product__items ">
                                <div class="product__items--thumbnail">
                                    <a class="product__items--link" href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <img class="product__items--img product__primary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                        <img class="product__items--img product__secondary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                    </a>
                                    <div class="product__badge">
                                        <span class="product__badge--items sale">Sale</span>
                                    </div>
                                    <?php if($row['p_qty'] == 0): ?>
                                    <div class="out-of-stock">
                                    <a class="product__add-to__cart--btn__style2" href="javascript:void(0)">
                                    <span class="add__to--cart__text"> Out Of Stock</span>
                                    </a>
                                    </div>
                                <?php else: ?>
                                    <a class="product__add-to__cart--btn__style2 " href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 14.706 13.534">
                                            <g transform="translate(0 0)">
                                              <g>
                                                <path data-name="Path 16787" d="M4.738,472.271h7.814a.434.434,0,0,0,.414-.328l1.723-6.316a.466.466,0,0,0-.071-.4.424.424,0,0,0-.344-.179H3.745L3.437,463.6a.435.435,0,0,0-.421-.353H.431a.451.451,0,0,0,0,.9h2.24c.054.257,1.474,6.946,1.555,7.33a1.36,1.36,0,0,0-.779,1.242,1.326,1.326,0,0,0,1.293,1.354h7.812a.452.452,0,0,0,0-.9H4.74a.451.451,0,0,1,0-.9Zm8.966-6.317-1.477,5.414H5.085l-1.149-5.414Z" transform="translate(0 -463.248)" fill="currentColor"></path>
                                                <path data-name="Path 16788" d="M5.5,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,5.5,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,6.793,478.352Z" transform="translate(-1.191 -466.622)" fill="currentColor"></path>
                                                <path data-name="Path 16789" d="M13.273,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,13.273,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,14.566,478.352Z" transform="translate(-2.875 -466.622)" fill="currentColor"></path>
                                              </g>
                                            </g>
                                        </svg>
                                        <span class="add__to--cart__text"> Shop Now</span>
                                    </a>
                                    <?php endif; ?>
                                    <ul class="product__items--action__style2">
                                    </ul>
                                </div>
                                <div class="product__items--content text-center">
                                    <span class="product__items--content__subtitle">Category</span>
                                    <h3 class="product__items--content__title h3"><a href="product.php?id=<?php echo $row['p_id']; ?>"><?php echo $row['p_name']; ?></a></h3>
                                    <div class="product__items--price">
                                        <span class="current__price">₹<?php echo $row['p_current_price']; ?> </span>
                                        <span class="price__divided"></span>
                                        <?php if($row['p_old_price'] != ''): ?>
                                        <span class="old__price">₹<?php echo $row['p_old_price']; ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <ul class="rating product__rating d-flex justify-content-center">
                                   <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                    </ul>
                                  
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                        
                        
                    </div>
                    <div class="swiper__nav--btn swiper-button-next"></div>
                    <div class="swiper__nav--btn swiper-button-prev"></div>
                </div>
            </div>
        </section>
        <!-- End product section -->
         <!-- Start shipping section -->
 <section class="shipping__section shipping__style3 pt-5 pb-5 bg-light">
            <div class="container-fluid">
                <div class="shipping__style--inner border-radius-10 d-flex justify-content-between">
                <?php
                $statement = $pdo->prepare("SELECT * FROM tbl_service");
                $statement->execute();
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    ?>
                <div class="shipping__style3--inner border-radius-10 d-flex justify-content-between">
                    <div class="shipping__style3--items d-flex align-items-center">
                        <div class="shipping__style3--icon">
                           <img src="assets/uploads/<?php echo $row['photo']; ?>" alt="<?php echo $row['title']; ?>">                            
                        </div>
                        <div class="shipping__style3--content">
                            <h2 class="shipping__style3--content__title"><?php echo $row['title'];  ?></h2>
                            <p class="shipping__style3--content__desc"><?php echo nl2br($row['content']); ?></p>
                        </div>
                    </div>
                    </div>
                    <?php
                }
            ?>
                </div>
            </div>
        </section>
        <!-- End shipping section -->
</main>
<?php include('include/footer.php')?>
<script>
// Initialize Fabric.js Canvas
const canvas = new fabric.Canvas('tshirtCanvas');
const productId = document.getElementById('productId').value;
// Load the T-shirt image
const tshirtImage = new fabric.Image.fromURL('assets/uploads/<?php echo $p_featured_photo; ?>', function (img) {
    img.scaleToHeight(500);
    img.scaleToWidth(400);
    canvas.setBackgroundImage(img, canvas.renderAll.bind(canvas));
});

// Modal handling
const customizeButton = document.getElementById('customizeButton');
const customizeModal = document.getElementById('customizeModal');
const closeModal = document.getElementById('closeModal');

function openModal() {
    customizeModal.style.display = 'flex';
}

function closeModalHandler() {
    customizeModal.style.display = 'none';
}

customizeButton.addEventListener('click', openModal);
closeModal.addEventListener('click', closeModalHandler);

window.addEventListener('click', (event) => {
    if (event.target === customizeModal) {
        closeModalHandler();
    }
});

// Logo upload
const uploadLogo = document.getElementById('uploadLogo');
uploadLogo.addEventListener('change', (event) => {
    const file = event.target.files[0];
    const reader = new FileReader();
    reader.onload = function () {
        fabric.Image.fromURL(reader.result, function (img) {
            img.scale(0.5);
            canvas.add(img);
            img.center();
            img.setCoords();
            canvas.renderAll();
        });
    };
    reader.readAsDataURL(file);
});

// Download the customized image
const downloadBtn = document.getElementById('downloadBtn');
downloadBtn.addEventListener('click', () => {
    const dataURL = canvas.toDataURL({ format: 'png' });
    const link = document.createElement('a');
    link.href = dataURL;
    link.download = 'customized-product.png';
    link.click();
});

// Save the customized image and add it to cart
const saveBtn = document.getElementById('saveBtn');
document.getElementById('saveBtn').addEventListener('click', function(event) {
    event.preventDefault();
    const dataURL = canvas.toDataURL({ format: 'png' });
    const logoData = document.getElementById('uploadLogo').files[0] ? document.getElementById('uploadLogo').files[0] : null;

    // Get logo base64 data if logo is uploaded
    let logoBase64 = null;
    if (logoData) {
        const reader = new FileReader();
        reader.onload = function() {
            logoBase64 = reader.result;
            sendCustomizationData(dataURL, logoBase64);
        };
        reader.readAsDataURL(logoData);
    } else {
        sendCustomizationData(dataURL, null);
    }
});

function sendCustomizationData(imageData, logoData) {
    const customizationId = Date.now().toString(); // Generate unique ID
    document.cookie = "customize_id=<?php echo $uniqueid1 ?>; expires=" + new Date(Date.now() + 30000).toUTCString() + "; path=/";

    fetch('save_customization.php', {
        method: 'POST',
        body: JSON.stringify({ 
            image: imageData, 
            logo: logoData, 
            productId: productId,
            customizationId: customizationId,
            c_php:"<?php echo $uniqueid1 ?>",
        }),
        headers: { 'Content-Type': 'application/json' }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Add hidden input for customization ID to the add-to-cart form
            const form = document.querySelector('form[name="form_add_to_cart"]');
            const customizationInput = document.createElement('input');
            customizationInput.type = 'hidden';
            customizationInput.name = 'customization_id';
            customizationInput.value = customizationId;
            form.appendChild(customizationInput);
            
            alert('Customization saved successfully!');
            closeModalHandler();
        } else {
            alert('Failed to save customization: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(error => {
        alert('Customization saved successfully!');
        closeModalHandler();
    });
}
</script>
<script>
    $(document).ready(function() {
    // Initialize zoom on the first image
    $(".zoom-img").elevateZoom({
        zoomWindowWidth: 400, // Set your desired zoom window size
        zoomWindowHeight: 500,
        lensWidth: 100, // Set the lens size
        lensHeight: 100
    });

    // Image selection script
    const imgs = document.querySelectorAll('.img-select a');
    const imgBtns = [...imgs];
    let imgId = 1;

    imgBtns.forEach((imgItem) => {
        imgItem.addEventListener('click', (event) => {
            event.preventDefault();
            imgId = imgItem.dataset.id;
            slideImage();
            changeMainImage();
        });
    });

    // Function to switch the main image
    function slideImage() {
        const displayWidth = document.querySelector('.img-showcase img:first-child').clientWidth;
        document.querySelector('.img-showcase').style.transform = `translateX(${- (imgId - 1) * displayWidth}px)`;
    }

    // Change the main image and reinitialize zoom
    function changeMainImage() {
        const newImage = document.querySelector(`#zoom-${imgId}`);

        // Remove any existing zoom
        $(".zoom-img").elevateZoom("destroy");

        // Add zoom to the new image
        $(newImage).addClass("zoom-img").elevateZoom({
            zoomWindowWidth: 400, // Set your desired zoom window size
        zoomWindowHeight: 500,
        lensWidth: 100, // Set the lens size
        lensHeight: 100
        });
    }

    // Re-adjust zoom on window resize
    window.addEventListener('resize', slideImage);
});

</script>
</body>

</html>