<?php include('include/header.php')?>
<?php
if (isset($_GET['email']) && isset($_GET['token'])) {
    $email = $_GET['email'];
    $token = $_GET['token'];

    // Fetch user details based on email and token
    $stmt = $pdo->prepare("SELECT * FROM tbl_customer WHERE cust_email = ? AND cust_token = ?");
    $stmt->execute([$email, $token]);
    $user = $stmt->fetch();

    if ($user) {
        // User found, proceed to OTP verification
        if (isset($_POST['verify_otp'])) {
            $otp = $_POST['otp'];
            $current_time = date('Y-m-d H:i:s');

            // Check if OTP matches and is within expiry time
            if ($otp == $user['cust_otp'] && $current_time <= $user['cust_otp_expiry']) {
                // OTP is valid, update the user status to verified
                $update = $pdo->prepare("UPDATE tbl_customer SET cust_status = 1 WHERE cust_email = ?");
                $update->execute([$email]);

                // Optionally, send a success message or redirect
                $success_message = "Email verified successfully!";
            } else {
                $error_message = "Invalid OTP or OTP expired.";
            }
        }
    } else {
        $error_message = "Invalid verification link.";
    }
} else {
    $error_message = "Missing parameters.";
}
?>
<section class="breadcrumb__section" style="background-color: #333; padding:20px 0;">
            <div class="container">
                <div class="row row-cols-1">
                    <div class="col">
                        <div class="breadcrumb__content text-center">
                            <h1 class="breadcrumb__content--title text-white mb-25">Verify OTP</h1>
                            <ul class="breadcrumb__content--menu d-flex justify-content-center">
                                <li class="breadcrumb__content--menu__items"><a class="text-white" href="index.php">Home</a></li>
                                <li class="breadcrumb__content--menu__items"><span class="text-white">Verify OTP</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
  <div class="login__section section--padding">
            <div class="container">
                 
                <form action="" method="post" class="">
                <?php $csrf->echoInputField(); ?>    
                    <div class="login__section--inner">
                        <div class="row row-cols-md-2 justify-content-center row-cols-1">
                            
                        <div class="col">
                                <div class="account__login register">
                                    <?php
                                if($error_message != '') {
                                    echo "<p class='error text-danger'>".$error_message."</p>";
                                }
                                if($success_message != '') {
                                    echo "<p class='success text-success'>".$success_message."</p>";
                                }
                                ?>  
                                    <div class="">
                                    <div class="account__login--header mb-25">
                                        <h2 class="account__login--header__title h3 mb-10">Verify OTP</h2>
                                                                         </div>
                                    <div class="account__login--inner row">
                                    <div class="col-md-6">    
                                    <label for="">Enter OTP *</label>
                                        <input class="account__login--input" type="text" name="otp" required>
                                    </div>
                                   
                                        <input class="account__login--btn primary__btn mb-10" type="submit" value="Verify OTP" name="verify_otp">
                                   
                                    </div>
                                </div>
                            </div>
                            </div>
                            
                        </div>
                    </div>
                </form>
            </div>     
        </div>
    // <?php
    // if (isset($error_message)) {
    //     echo "<p class='error text-danger'>$error_message</p>";
    // }
    // if (isset($success_message)) {
    //     echo "<p class='success text-success'>$success_message</p>";
    // }
    // ?>

    <!--<form action="" method="POST">-->
    <!--    <label for="otp">Enter OTP: </label>-->
    <!--    <input type="text" name="otp" required>-->
    <!--    <button type="submit" name="verify_otp">Verify OTP</button>-->
    <!--</form>-->
<?php include('include/footer.php')?>
</body>

</html>
