<?php include('include/header.php')?>
<?php
$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
$statement->execute();
$result = $statement->fetchAll(PDO::FETCH_ASSOC);
foreach ($result as $row)
{
    $cta_title = $row['cta_title'];
    $cta_content = $row['cta_content'];
    $cta_read_more_text = $row['cta_read_more_text'];
    $cta_read_more_url = $row['cta_read_more_url'];
    $cta_photo = $row['cta_photo'];
    $featured_product_title = $row['featured_product_title'];
    $featured_product_subtitle = $row['featured_product_subtitle'];
    $latest_product_title = $row['latest_product_title'];
    $latest_product_subtitle = $row['latest_product_subtitle'];
    $popular_product_title = $row['popular_product_title'];
    $popular_product_subtitle = $row['popular_product_subtitle'];
    $total_featured_product_home = $row['total_featured_product_home'];
    $total_latest_product_home = $row['total_latest_product_home'];
    $total_popular_product_home = $row['total_popular_product_home'];
    $home_service_on_off = $row['home_service_on_off'];
    $home_welcome_on_off = $row['home_welcome_on_off'];
    $home_featured_product_on_off = $row['home_featured_product_on_off'];
    $home_latest_product_on_off = $row['home_latest_product_on_off'];
    $home_popular_product_on_off = $row['home_popular_product_on_off'];

}


?>
<!-- Start preloader -->
 <div id="preloader">
        <div id="ctn-preloader" class="ctn-preloader">
            <div class="animation-preloader">
                <div class="spinner"></div>
                <div class="txt-loading">
                    <span data-text-preloader="L" class="letters-loading">
                        L
                    </span>
                    
                    <span data-text-preloader="O" class="letters-loading">
                        O
                    </span>
                    
                    <span data-text-preloader="A" class="letters-loading">
                        A
                    </span>
                    
                    <span data-text-preloader="D" class="letters-loading">
                        D
                    </span>
                    
                    <span data-text-preloader="I" class="letters-loading">
                        I
                    </span>
                    
                    <span data-text-preloader="N" class="letters-loading">
                        N
                    </span>
                    
                    <span data-text-preloader="G" class="letters-loading">
                        G
                    </span>
                </div>
            </div>	
            <div class="loader-section section-left"></div>
            <div class="loader-section section-right"></div>
        </div>
    </div>
    <!-- End preloader -->
<main class="main__content_wrapper">
<!-- Start slider section -->
<section class="hero__slider--section color-scheme-2">
    <div class="hero__slider--inner hero__slider--activation swiper">
        <div class="hero__slider--wrapper swiper-wrapper">
            
            <?php
            // Query the database for slider data
            $statement = $pdo->prepare("SELECT * FROM tbl_slider");
            $statement->execute();
            $result = $statement->fetchAll(PDO::FETCH_ASSOC);
            $i = 0;

            // Loop through the results and generate Swiper slides
            foreach ($result as $row) {
                ?>
                <div class="swiper-slide">
                    <div class="hero__slider--items home2__slider--bg" style="background-image:url(assets/uploads/<?php echo $row['photo']; ?>);">
                        <div class="container-fluid">
                            <div class="hero__slider--items__inner hero__slider--bg2__inner">
                                <div class="row row-cols-1">
                                    <div class="col">
                                        <div class="slider__content">
                                            <h2 class="slider__content--maintitle h1">
                                                <?php echo $row['heading']; ?>
                                            </h2>
                                            <p class="slider__content--desc desc2 mb-40">
                                                <?php echo nl2br($row['content']); ?>
                                            </p>
                                            <!--<a href="<?php echo $row['button_url']; ?>" target="_blank" class="bg__secondary2 slider__btn primary__btn">-->
                                            <!--    <?php echo $row['button_text']; ?>-->
                                            <!--    <svg class="primary__btn--arrow__icon" xmlns="http://www.w3.org/2000/svg" width="20.2" height="12.2" viewBox="0 0 6.2 6.2">-->
                                            <!--        <path d="M7.1,4l-.546.546L8.716,6.713H4v.775H8.716L6.554,9.654,7.1,10.2,9.233,8.067,10.2,7.1Z" transform="translate(-4 -4)" fill="currentColor"></path>-->
                                            <!--    </svg>-->
                                            <!--</a>-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $i++;
            }
            ?>

        </div>

        <!-- Navigation buttons for the swiper -->
        <div class="swiper__nav--btn swiper-button-next"></div>
        <div class="swiper__nav--btn swiper-button-prev"></div>
    </div>
</section>

        <!-- End slider section -->
 


<?php if($home_service_on_off == 1): ?>
 <!-- Start shipping section -->
 <section class="shipping__section shipping__style3 pt-5 pb-5 bg-light">
            <div class="container-fluid">
                <div class="shipping__style--inner border-radius-10 d-flex justify-content-between">
                <?php
                $statement = $pdo->prepare("SELECT * FROM tbl_service");
                $statement->execute();
                $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                foreach ($result as $row) {
                    ?>
                <div class="shipping__style3--inner border-radius-10 d-flex justify-content-between">
                    <div class="shipping__style3--items d-flex align-items-center">
                        <div class="shipping__style3--icon">
                           <img src="assets/uploads/<?php echo $row['photo']; ?>" alt="<?php echo $row['title']; ?>">                            
                        </div>
                        <div class="shipping__style3--content">
                            <h2 class="shipping__style3--content__title"><?php echo $row['title'];  ?></h2>
                            <p class="shipping__style3--content__desc"><?php echo nl2br($row['content']); ?></p>
                        </div>
                    </div>
                    </div>
                    <?php
                }
            ?>
                </div>
            </div>
        </section>
        <!-- End shipping section -->
<?php endif; ?>

<?php if($home_featured_product_on_off == 1): ?>
 <!-- Start product section -->
 <section class="product__section section--padding">
            <div class="container-fluid">
                <div class="section__heading text-center mb-50">
                    <h2 class="section__heading--maintitle"><?php echo $featured_product_title; ?></h2>
                    <h4 class="text-muted mt-2"><?php echo $featured_product_subtitle; ?></h4>
                </div>
                <div class="product__section--inner product__swiper--activation swiper">
                    <div class="swiper-wrapper">
                    <?php
                    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE p_is_featured=? AND p_is_active=? LIMIT ".$total_featured_product_home);
                    $statement->execute(array(1,1));
                    $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                    foreach ($result as $row) {
                        ?>
                        <div class="swiper-slide">
                        <div class="product__items ">
                                <div class="product__items--thumbnail">
                                    <a class="product__items--link" href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <img class="product__items--img product__primary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                        <img class="product__items--img product__secondary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                    </a>
                                    <div class="product__badge">
                                        <span class="product__badge--items sale">Sale</span>
                                    </div>
                                    <?php if($row['p_qty'] == 0): ?>
                                    <div class="out-of-stock">
                                    <a class="product__add-to__cart--btn__style2" href="javascript:void(0)">
                                    <span class="add__to--cart__text"> Out Of Stock</span>
                                    </a>
                                    </div>
                                <?php else: ?>
                                    <a class="product__add-to__cart--btn__style2 " href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <!--<svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 14.706 13.534">-->
                                        <!--    <g transform="translate(0 0)">-->
                                        <!--      <g>-->
                                        <!--        <path data-name="Path 16787" d="M4.738,472.271h7.814a.434.434,0,0,0,.414-.328l1.723-6.316a.466.466,0,0,0-.071-.4.424.424,0,0,0-.344-.179H3.745L3.437,463.6a.435.435,0,0,0-.421-.353H.431a.451.451,0,0,0,0,.9h2.24c.054.257,1.474,6.946,1.555,7.33a1.36,1.36,0,0,0-.779,1.242,1.326,1.326,0,0,0,1.293,1.354h7.812a.452.452,0,0,0,0-.9H4.74a.451.451,0,0,1,0-.9Zm8.966-6.317-1.477,5.414H5.085l-1.149-5.414Z" transform="translate(0 -463.248)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16788" d="M5.5,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,5.5,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,6.793,478.352Z" transform="translate(-1.191 -466.622)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16789" d="M13.273,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,13.273,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,14.566,478.352Z" transform="translate(-2.875 -466.622)" fill="currentColor"></path>-->
                                        <!--      </g>-->
                                        <!--    </g>-->
                                        <!--</svg>-->
                                        <span class="add__to--cart__text"> Shop Now</span>
                                    </a>
                                    <?php endif; ?>
                                    <ul class="product__items--action__style2">
                                        <!-- <li class="product__items--action__style2--list">
                                            <a class="product__items--action__style2--btn" href="#">
                                                <svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="23.51" height="21.443" viewBox="0 0 512 512"><path d="M352.92 80C288 80 256 144 256 144s-32-64-96.92-64c-52.76 0-94.54 44.14-95.08 96.81-1.1 109.33 86.73 187.08 183 252.42a16 16 0 0018 0c96.26-65.34 184.09-143.09 183-252.42-.54-52.67-42.32-96.81-95.08-96.81z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"></path></svg>
                                                <span class="visually-hidden">Wishlist</span> 
                                            </a>
                                        </li> -->
                                        <!-- <li class="product__items--action__style2--list">
                                            <a class="product__items--action__style2--btn" data-open="modal1" href="javascript:void(0)">
                                                <svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg"  width="22.51" height="20.443" viewBox="0 0 512 512"><path d="M255.66 112c-77.94 0-157.89 45.11-220.83 135.33a16 16 0 00-.27 17.77C82.92 340.8 161.8 400 255.66 400c92.84 0 173.34-59.38 221.79-135.25a16.14 16.14 0 000-17.47C428.89 172.28 347.8 112 255.66 112z" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/><circle cx="256" cy="256" r="80" fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"/></svg>
                                                <span class="visually-hidden">Quick View</span>
                                            </a>
                                        </li> -->
                                    </ul>
                                </div>
                                <div class="product__items--content text-center">
                                    <!--<span class="product__items--content__subtitle">Category</span>-->
                                    <h3 class="product__items--content__title h3"><a href="product.php?id=<?php echo $row['p_id']; ?>"><?php echo $row['p_name']; ?></a></h3>
                                    <div class="product__items--price">
                                        <span class="current__price">₹<?php echo $row['p_current_price']; ?> </span>
                                        <span class="price__divided"></span>
                                        <?php if($row['p_old_price'] != ''): ?>
                                        <span class="old__price">₹<?php echo $row['p_old_price']; ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <ul class="rating product__rating d-flex justify-content-center">
                                   <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>

                                    </ul>
                                  
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                        
                    </div>
                    <div class="swiper__nav--btn swiper-button-next"></div>
                    <div class="swiper__nav--btn swiper-button-prev"></div>
                </div>
            </div>
        </section>
        <!-- End product section -->
<?php endif; ?>

<?php if($home_latest_product_on_off == 1): ?>
 <!-- Start product section -->
 <section class="product__section section--padding bg-light">
            <div class="container-fluid">
                <div class="section__heading text-center mb-50">
                    <h2 class="section__heading--maintitle"><?php echo $latest_product_title; ?></h2>
                    <h4 class="text-muted mt-2"><?php echo $latest_product_subtitle; ?></h4>
                </div>
                <div class="product__section--inner product__swiper--activation swiper">
                    <div class="swiper-wrapper">
                    <?php
                    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE p_is_active=? ORDER BY p_id DESC LIMIT ".$total_latest_product_home);
                    $statement->execute(array(1));
                    $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                    foreach ($result as $row) {
                        ?>
                        <div class="swiper-slide">
                        <div class="product__items ">
                                <div class="product__items--thumbnail">
                                    <a class="product__items--link" href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <img class="product__items--img product__primary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                        <img class="product__items--img product__secondary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                    </a>
                                    <div class="product__badge">
                                        <span class="product__badge--items sale">Sale</span>
                                    </div>
                                    <?php if($row['p_qty'] == 0): ?>
                                    <div class="out-of-stock">
                                    <a class="product__add-to__cart--btn__style2" href="javascript:void(0)">
                                    <span class="add__to--cart__text"> Out Of Stock</span>
                                    </a>
                                    </div>
                                <?php else: ?>
                                    <a class="product__add-to__cart--btn__style2 " href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <!--<svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 14.706 13.534">-->
                                        <!--    <g transform="translate(0 0)">-->
                                        <!--      <g>-->
                                        <!--        <path data-name="Path 16787" d="M4.738,472.271h7.814a.434.434,0,0,0,.414-.328l1.723-6.316a.466.466,0,0,0-.071-.4.424.424,0,0,0-.344-.179H3.745L3.437,463.6a.435.435,0,0,0-.421-.353H.431a.451.451,0,0,0,0,.9h2.24c.054.257,1.474,6.946,1.555,7.33a1.36,1.36,0,0,0-.779,1.242,1.326,1.326,0,0,0,1.293,1.354h7.812a.452.452,0,0,0,0-.9H4.74a.451.451,0,0,1,0-.9Zm8.966-6.317-1.477,5.414H5.085l-1.149-5.414Z" transform="translate(0 -463.248)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16788" d="M5.5,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,5.5,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,6.793,478.352Z" transform="translate(-1.191 -466.622)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16789" d="M13.273,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,13.273,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,14.566,478.352Z" transform="translate(-2.875 -466.622)" fill="currentColor"></path>-->
                                        <!--      </g>-->
                                        <!--    </g>-->
                                        <!--</svg>-->
                                        <span class="add__to--cart__text"> Shop Now</span>
                                    </a>
                                    <?php endif; ?>
                                    <ul class="product__items--action__style2">
                                    </ul>
                                </div>
                                <div class="product__items--content text-center">
                                    <!--<span class="product__items--content__subtitle">Category</span>-->
                                    <h3 class="product__items--content__title h3"><a href="product.php?id=<?php echo $row['p_id']; ?>"><?php echo $row['p_name']; ?></a></h3>
                                    <div class="product__items--price">
                                        <span class="current__price">₹<?php echo $row['p_current_price']; ?> </span>
                                        <span class="price__divided"></span>
                                        <?php if($row['p_old_price'] != ''): ?>
                                        <span class="old__price">₹<?php echo $row['p_old_price']; ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <ul class="rating product__rating d-flex justify-content-center">
                                   <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                        <li class="rating__list">
                                            <span class="rating__list--icon">
                                                <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">
                                                <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </li>
                                    </ul>
                                  
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                        
                    </div>
                    <div class="swiper__nav--btn swiper-button-next"></div>
                    <div class="swiper__nav--btn swiper-button-prev"></div>
                </div>
            </div>
        </section>
        <!-- End product section -->
<?php endif; ?>

<?php if($home_popular_product_on_off == 1): ?>
 <!-- Start product section -->
 <section class="product__section section--padding">
            <div class="container-fluid">
                <div class="section__heading text-center mb-50">
                    <h2 class="section__heading--maintitle"><?php echo $popular_product_title; ?></h2>
                    <h4 class="text-muted mt-2"><?php echo $popular_product_subtitle; ?></h4>
                </div>
                <div class="product__section--inner product__swiper--activation swiper">
                    <div class="swiper-wrapper">
                    <?php
                    $statement = $pdo->prepare("SELECT * FROM tbl_product WHERE p_is_active=? ORDER BY p_total_view DESC LIMIT ".$total_popular_product_home);
                    $statement->execute(array(1));
                    $result = $statement->fetchAll(PDO::FETCH_ASSOC);                            
                    foreach ($result as $row) {
                        ?>
                        <div class="swiper-slide">
                        <div class="product__items ">
                                <div class="product__items--thumbnail">
                                    <a class="product__items--link" href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <img class="product__items--img product__primary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                        <img class="product__items--img product__secondary--img" src="assets/uploads/<?php echo $row['p_featured_photo']; ?>" alt="product-img">
                                    </a>
                                    <div class="product__badge">
                                        <span class="product__badge--items sale">Sale</span>
                                    </div>
                                    <?php if($row['p_qty'] == 0): ?>
                                    <div class="out-of-stock">
                                    <a class="product__add-to__cart--btn__style2" href="javascript:void(0)">
                                    <span class="add__to--cart__text"> Out Of Stock</span>
                                    </a>
                                    </div>
                                <?php else: ?>
                                    <a class="product__add-to__cart--btn__style2 " href="product.php?id=<?php echo $row['p_id']; ?>">
                                        <!--<svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" width="22.51" height="20.443" viewBox="0 0 14.706 13.534">-->
                                        <!--    <g transform="translate(0 0)">-->
                                        <!--      <g>-->
                                        <!--        <path data-name="Path 16787" d="M4.738,472.271h7.814a.434.434,0,0,0,.414-.328l1.723-6.316a.466.466,0,0,0-.071-.4.424.424,0,0,0-.344-.179H3.745L3.437,463.6a.435.435,0,0,0-.421-.353H.431a.451.451,0,0,0,0,.9h2.24c.054.257,1.474,6.946,1.555,7.33a1.36,1.36,0,0,0-.779,1.242,1.326,1.326,0,0,0,1.293,1.354h7.812a.452.452,0,0,0,0-.9H4.74a.451.451,0,0,1,0-.9Zm8.966-6.317-1.477,5.414H5.085l-1.149-5.414Z" transform="translate(0 -463.248)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16788" d="M5.5,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,5.5,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,6.793,478.352Z" transform="translate(-1.191 -466.622)" fill="currentColor"></path>-->
                                        <!--        <path data-name="Path 16789" d="M13.273,478.8a1.294,1.294,0,1,0,1.293-1.353A1.325,1.325,0,0,0,13.273,478.8Zm1.293-.451a.452.452,0,1,1-.431.451A.442.442,0,0,1,14.566,478.352Z" transform="translate(-2.875 -466.622)" fill="currentColor"></path>-->
                                        <!--      </g>-->
                                        <!--    </g>-->
                                        <!--</svg>-->
                                        <span class="add__to--cart__text"> Shop Now</span>
                                    </a>
                                    <?php endif; ?>
                                    <ul class="product__items--action__style2">
                                    </ul>
                                </div>
                                <div class="product__items--content text-center">
                                    <!--<span class="product__items--content__subtitle">Category</span>-->
                                    <h3 class="product__items--content__title h3"><a href="product.php?id=<?php echo $row['p_id']; ?>"><?php echo $row['p_name']; ?></a></h3>
                                    <div class="product__items--price">
                                        <span class="current__price">₹<?php echo $row['p_current_price']; ?> </span>
                                        <span class="price__divided"></span>
                                        <?php if($row['p_old_price'] != ''): ?>
                                        <span class="old__price">₹<?php echo $row['p_old_price']; ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <ul class="rating product__rating d-flex justify-content-center">
                                    <?php
                                    $t_rating = 0;
                                    $statement1 = $pdo->prepare("SELECT * FROM tbl_rating WHERE p_id=?");
                                    $statement1->execute(array($row['p_id']));
                                    $tot_rating = $statement1->rowCount();
                                    if($tot_rating == 0) {
                                        $avg_rating = 0;
                                    } else {
                                        $result1 = $statement1->fetchAll(PDO::FETCH_ASSOC);
                                        foreach ($result1 as $row1) {
                                            $t_rating = $t_rating + $row1['rating'];
                                        }
                                        $avg_rating = $t_rating / $tot_rating;
                                    }
                                    ?>
                                     <?php
                                    if($avg_rating == 0) {
                                        echo '';
                                    }
                                    elseif($avg_rating == 1.5) {
                                        echo '
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-half-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                        ';
                                    } 
                                    elseif($avg_rating == 2.5) {
                                        echo '
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-half-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                        ';
                                    }
                                    elseif($avg_rating == 3.5) {
                                        echo '
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-half-o"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-o"></i></li>
                                        ';
                                    }
                                    elseif($avg_rating == 4.5) {
                                        echo '
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star"></i></li>
                                             <li class="rating__list"><i class="fa fa-star-half-o"></i></li>
                                        ';
                                    }
                                    else {
                                        for($i=1;$i<=5;$i++) {
                                            ?>
                                            <?php if($i>$avg_rating): ?>
                                                <i class="fa fa-star-o"></i>
                                            <?php else: ?>
                                                <i class="fa fa-star"></i>
                                            <?php endif; ?>
                                            <?php
                                        }
                                    }
                                    ?>
                                    </ul>
                                  
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                        
                    </div>
                    <div class="swiper__nav--btn swiper-button-next"></div>
                    <div class="swiper__nav--btn swiper-button-prev"></div>
                </div>
            </div>
        </section>
        <!-- End product section -->
<?php endif; ?>



 <!-- Start banner section -->
 <section class="banner__section section--padding">
            <div class="container-fluid">
                <div class="row row-cols-md-2 row-cols-1 mb--n28">
                    <div class="col mb-28">
                        <div class="banner__items position__relative">
                            <a class="banner__items--thumbnail " href="#"><img class="banner__items--thumbnail__img banner__img--max__height" src="assets/img/banner/1.jpg" alt="banner-img">
                                <div class="banner__items--content">
                                    <span class="banner__items--content__subtitle d-none d-lg-block text-white">Pick Your Items</span>
                                    <h2 class="banner__items--content__title h3 text-white">Up to 25% Off Order Now</h2>
                                    <span class="banner__items--content__link text-white"><u>Shop now</u></span>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="col mb-28">
                        <div class="banner__items position__relative">
                            <a class="banner__items--thumbnail " href="#"><img class="banner__items--thumbnail__img banner__img--max__height" src="assets/img/banner/2.jpg" alt="banner-img">
                                <div class="banner__items--content">
                                    <span class="banner__items--content__subtitle d-none d-lg-block">Special offer</span>
                                    <h2 class="banner__items--content__title h3">Up to 35% Off Order Now</h2>
                                    <span class="banner__items--content__link"><u>Shop Now</u> </span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End banner section -->
        <?php
// Loop through the top categories
$statement = $pdo->prepare("SELECT * FROM tbl_top_category WHERE show_on_menu=1");
$statement->execute();
$result = $statement->fetchAll(PDO::FETCH_ASSOC);

foreach ($result as $row) {
    $tcat_id = $row['tcat_id'];

    // Check if there are products for the current top category
    $statement1 = $pdo->prepare("
        SELECT COUNT(*) as product_count
        FROM tbl_product p
        INNER JOIN tbl_end_category e ON p.ecat_id = e.ecat_id
        INNER JOIN tbl_mid_category m ON e.mcat_id = m.mcat_id
        WHERE m.tcat_id = ?
    ");
    $statement1->execute([$tcat_id]);
    $productCount = $statement1->fetch(PDO::FETCH_ASSOC)['product_count'];

    // If no products exist, skip this section
    if ($productCount == 0) {
        continue;
    }
    ?>
    <section class="new__product--section section--padding pt-0">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-md-5">
                    <div class="product__collection--content">
                        <h2 class="product__collection--content__title"><?php echo $row['tcat_name']; ?> Collection</h2>
                        <p class="product__collection--content__desc">
                            Explore the latest products from the <?php echo $row['tcat_name']; ?> category.
                        </p>
                    </div>
                </div>
                <div class="col-lg-8 col-md-7">
                    <div class="new__product--sidebar position__relative">
                        <div class="product__swiper--column3 swiper">
                            <div class="swiper-wrapper">
                                <?php
                                // Fetch and display products for the current top category
                                $statement2 = $pdo->prepare("
                                    SELECT p.*
                                    FROM tbl_product p
                                    INNER JOIN tbl_end_category e ON p.ecat_id = e.ecat_id
                                    INNER JOIN tbl_mid_category m ON e.mcat_id = m.mcat_id
                                    WHERE m.tcat_id = ?
                                ");
                                $statement2->execute([$tcat_id]);
                                $products = $statement2->fetchAll(PDO::FETCH_ASSOC);

                                foreach ($products as $product) {
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="new__product--items">
                                            <div class="new__product--thumbnail">
                                                <a class="new__product--thumbnail__link" href="product.php?id=<?php echo $product['p_id']; ?>">
                                                    <img class="new__product--thumbnail__img" src="assets/uploads/<?php echo $product['p_featured_photo']; ?>" alt="product-img">
                                                </a>
                                            </div>
                                            <div class="new__product--content">
                                                <h3 class="new__product--content__title">
                                                    <a href="product.php?id=<?php echo $product['p_id']; ?>"><?php echo $product['p_name']; ?></a>
                                                </h3>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="swiper__nav--btn style3 swiper-button-next"></div>
                        <div class="swiper__nav--btn style3 swiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
}
?>

       
         <!-- Start testimonial section -->
        <!--<section class="testimonial__section section--padding">-->
        <!--    <div class="container-fluid">-->
        <!--        <div class="section__heading text-center mb-40">-->
        <!--            <h2 class="section__heading--maintitle">Our Clients Say</h2>-->
        <!--        </div>-->
        <!--        <div class="testimonial__section--inner testimonial__swiper--activation swiper">-->
        <!--            <div class="swiper-wrapper">-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="testimonial__items text-center">-->
        <!--                        <div class="testimonial__items--thumbnail">-->
        <!--                            <img class="testimonial__items--thumbnail__img border-radius-50" src="assets/img/other/testimonial-thumb1.png" alt="testimonial-img">-->
        <!--                        </div>-->
        <!--                        <div class="testimonial__items--content">-->
        <!--                            <h3 class="testimonial__items--title">Nike Mardson</h3>-->
        <!--                            <span class="testimonial__items--subtitle">fashion</span>-->
        <!--                            <p class="testimonial__items--desc">Lorem ipsum dolor sit amet, consectetur adipisicin elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim </p>-->
        <!--                            <ul class="rating testimonial__rating d-flex justify-content-center">-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->

        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="testimonial__items text-center">-->
        <!--                        <div class="testimonial__items--thumbnail">-->
        <!--                            <img class="testimonial__items--thumbnail__img border-radius-50" src="assets/img/other/testimonial-thumb2.png" alt="testimonial-img">-->
        <!--                        </div>-->
        <!--                        <div class="testimonial__items--content">-->
        <!--                            <h3 class="testimonial__items--title">Will Jackson</h3>-->
        <!--                            <span class="testimonial__items--subtitle">fashion</span>-->
        <!--                            <p class="testimonial__items--desc">Lorem ipsum dolor sit amet, consectetur adipisicin elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim </p>-->
        <!--                            <ul class="rating testimonial__rating d-flex justify-content-center">-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->

        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="testimonial__items text-center">-->
        <!--                        <div class="testimonial__items--thumbnail">-->
        <!--                            <img class="testimonial__items--thumbnail__img border-radius-50" src="assets/img/other/testimonial-thumb3.png" alt="testimonial-img">-->
        <!--                        </div>-->
        <!--                        <div class="testimonial__items--content">-->
        <!--                            <h3 class="testimonial__items--title">James Hamesk</h3>-->
        <!--                            <span class="testimonial__items--subtitle">fashion</span>-->
        <!--                            <p class="testimonial__items--desc">Lorem ipsum dolor sit amet, consectetur adipisicin elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim </p>-->
        <!--                            <ul class="rating testimonial__rating d-flex justify-content-center">-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->

        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--                <div class="swiper-slide">-->
        <!--                    <div class="testimonial__items text-center">-->
        <!--                        <div class="testimonial__items--thumbnail">-->
        <!--                            <img class="testimonial__items--thumbnail__img border-radius-50" src="assets/img/other/testimonial-thumb1.png" alt="testimonial-img">-->
        <!--                        </div>-->
        <!--                        <div class="testimonial__items--content">-->
        <!--                            <h3 class="testimonial__items--title">Nike Mardson</h3>-->
        <!--                            <span class="testimonial__items--subtitle">fashion</span>-->
        <!--                            <p class="testimonial__items--desc">Lorem ipsum dolor sit amet, consectetur adipisicin elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim </p>-->
        <!--                            <ul class="rating testimonial__rating d-flex justify-content-center">-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->
        <!--                                <li class="rating__list">-->
        <!--                                    <span class="rating__list--icon">-->
        <!--                                        <svg class="rating__list--icon__svg" xmlns="http://www.w3.org/2000/svg" width="14.105" height="14.732" viewBox="0 0 10.105 9.732">-->
        <!--                                        <path data-name="star - Copy" d="M9.837,3.5,6.73,3.039,5.338.179a.335.335,0,0,0-.571,0L3.375,3.039.268,3.5a.3.3,0,0,0-.178.514L2.347,6.242,1.813,9.4a.314.314,0,0,0,.464.316L5.052,8.232,7.827,9.712A.314.314,0,0,0,8.292,9.4L7.758,6.242l2.257-2.231A.3.3,0,0,0,9.837,3.5Z" transform="translate(0 -0.018)" fill="currentColor"></path>-->
        <!--                                        </svg>-->
        <!--                                    </span>-->
        <!--                                </li>-->

        <!--                            </ul>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--            <div class="testimonial__pagination swiper-pagination"></div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->
        <!-- End testimonial section -->
</main>
<?php include('include/footer.php')?>
</body>

</html>