<?php
session_start();
require_once('../../admin/inc/config.php');

// Razorpay API credentials
$razorpay_key = 'rzp_live_ZsfcHOE1qBZL0x';
$razorpay_secret = 'NUMelK33P0bZmpDfPMRK4JWA';

// Get the payment amount from POST data
$amount = isset($_POST['amount']) ? intval($_POST['amount']) * 100 : 0; 

if ($amount <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid amount.']);
    exit();
}

try {
    // Initialize cURL for Razorpay order creation
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.razorpay.com/v1/orders");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, $razorpay_key . ":" . $razorpay_secret);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'amount' => $amount,
        'currency' => 'INR',
        'receipt' => 'order_receipt_' . time(),
        'payment_capture' => 1
    ]));

    $apiResponse = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception('Curl error: ' . curl_error($ch));
    }

    $response_data = json_decode($apiResponse, true);
    curl_close($ch);

    if (isset($response_data['id']) && isset($response_data['status']) && $response_data['status'] === 'created') {
        // Store the order details in the session for later verification
        $_SESSION['razorpay_order_id'] = $response_data['id'];

        // Insert payment details with 'Pending' status
        $payment_date = date('Y-m-d H:i:s');
        $item_number = time();

        $stmt = $pdo->prepare("INSERT INTO tbl_payment (
            customer_id, customer_name, customer_email, payment_date,
            txnid, paid_amount, payment_method, payment_status,shipping_status,payment_id
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_SESSION['customer']['cust_id'],
            $_SESSION['customer']['cust_name'],
            $_SESSION['customer']['cust_email'],
            $payment_date,
            '',
            $amount / 100,
            'Razorpay',
            'Pending',
            'Pending',
            $item_number
        ]);

        // Store payment_id in session for linking orders later
        $_SESSION['payment_id'] = $item_number;

        // Return order_id to the client
        echo json_encode(['success' => true, 'order_id' => $response_data['id']]);
    } else {
        throw new Exception('Order creation failed: ' . json_encode($response_data));
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
