<?php
session_start();
include("admin/inc/config.php");
include("admin/inc/functions.php");
include("admin/inc/CSRF_Protect.php");

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

try {
    // Get and validate JSON data
    $jsonData = file_get_contents('php://input');
    if (!$jsonData) {
        throw new Exception('No data received');
    }
    
    $data = json_decode($jsonData, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON data');
    }

    // Validate required fields
    if (empty($data['productId']) || empty($data['image']) || empty($data['customizationId'])) {
        throw new Exception('Missing required fields');
    }

    $productId = $data['productId'];
    $customizationId = $data['customizationId'];
    $imageData = $data['image'];
    $logoData = isset($data['logo']) ? $data['logo'] : null;

    // Create directory if it doesn't exist
    $uploadDir = 'assets/uploads/customized/';
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Process main customized image
    $imageData = preg_replace('#^data:image/\w+;base64,#i', '', $imageData);
    $decodedImage = base64_decode($imageData);
    $customImagePath = $uploadDir . 'custom_' . $customizationId . '.png';
    
    if (file_put_contents($customImagePath, $decodedImage) === false) {
        throw new Exception('Failed to save customized image');
    }

    // Process logo if provided
    $logoPath = null;
    if ($logoData) {
        $logoData = preg_replace('#^data:image/\w+;base64,#i', '', $logoData);
        $decodedLogo = base64_decode($logoData);
        $logoPath = $uploadDir . 'logo_' . $customizationId . '.png';
        
        if (file_put_contents($logoPath, $decodedLogo) === false) {
            throw new Exception('Failed to save logo image');
        }
    }

   

    // Store in session for cart
    if (!isset($_SESSION['customizations'])) {
        $_SESSION['customizations'] = [];
    }

    $_SESSION['customizations'][$data['c_php']] = [
        'product_id' => $productId,
        'customization_id' => $data['c_php'],
        'custom_image' => $customImagePath,
        'logo' => $logoPath,
        'timestamp' => time()
    ];

    // Return success response
    echo json_encode([
        'success' => true,
        'customizationId' => $customizationId,
        'customImagePath' => $customImagePath,
        'logoPath' => $logoPath
    ]);

} catch (Exception $e) {
    // Log error (you should implement proper error logging)
    error_log('Customization Error: ' . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Error processing customization: ' . $e->getMessage()
    ]);
}
?>